/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.test;

import java.util.Locale;
import java.util.StringTokenizer;

public class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber v1_0 = new VersionNumber("1.0");
    public static final VersionNumber v1_0_1 = new VersionNumber("1.0.1");
    public static final VersionNumber v1_0_2 = new VersionNumber("1.0.2");
    public static final VersionNumber v1_0_3 = new VersionNumber("1.0.3");
    public static final VersionNumber v2_0 = new VersionNumber("2.0");
    public static final VersionNumber v2_1 = new VersionNumber("2.1");
    private final int[] digits;

    public VersionNumber(String num) {
        StringTokenizer tokens = new StringTokenizer(num, ".");
        this.digits = new int[tokens.countTokens()];
        if (this.digits.length < 2) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase(Locale.ENGLISH);
            if (token.equals("*")) {
                this.digits[i++] = 1000;
                continue;
            }
            if (token.startsWith("ea")) {
                if (token.length() == 2) {
                    this.digits[i++] = -1000;
                    continue;
                }
                this.digits[i++] = -1000 + Integer.parseInt(token.substring(2));
                continue;
            }
            this.digits[i++] = Integer.parseInt(token);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.digits.length; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(Integer.toString(this.digits[i]));
        }
        return buf.toString();
    }

    public boolean isOlderThan(VersionNumber rhs) {
        return this.compareTo(rhs) < 0;
    }

    public boolean isNewerThan(VersionNumber rhs) {
        return this.compareTo(rhs) > 0;
    }

    public boolean equals(Object o) {
        if (o instanceof VersionNumber) {
            return this.compareTo((VersionNumber)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        int x = 0;
        for (int i : this.digits) {
            x = x << 1 | i;
        }
        return x;
    }

    @Override
    public int compareTo(VersionNumber rhs) {
        int i = 0;
        while (i != this.digits.length || i != rhs.digits.length) {
            if (i == this.digits.length) {
                return -1;
            }
            if (i == rhs.digits.length) {
                return 1;
            }
            int r = this.digits[i] - rhs.digits[i];
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }
}

