/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.test;

import com.sun.istack.test.VersionNumber;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class VersionProcessor {
    private final VersionNumber since;
    private final VersionNumber until;
    private final Set<Object> excludeVersions;
    private static final Object ALL_VERSION = new Object();
    public static final VersionProcessor DEFAULT = new VersionProcessor();

    private VersionProcessor() {
        this.since = null;
        this.until = null;
        this.excludeVersions = null;
    }

    public VersionProcessor(String sinceValue, String untilValue, String excludeFromValue) {
        this.since = sinceValue != null && !sinceValue.trim().isEmpty() ? new VersionNumber(sinceValue) : null;
        this.until = untilValue != null && !untilValue.trim().isEmpty() ? new VersionNumber(untilValue) : null;
        if (excludeFromValue != null && !excludeFromValue.trim().isEmpty()) {
            this.excludeVersions = new HashSet<Object>();
            String v = excludeFromValue.trim();
            if (v.equals("all")) {
                this.excludeVersions.add(ALL_VERSION);
            } else {
                StringTokenizer tokens = new StringTokenizer(v);
                while (tokens.hasMoreTokens()) {
                    this.excludeVersions.add(new VersionNumber(tokens.nextToken()));
                }
            }
        } else {
            this.excludeVersions = null;
        }
    }

    public VersionProcessor(Document testSpecMeta) {
        this(testSpecMeta.getDocumentElement());
    }

    public VersionProcessor(Element e) {
        this(e.getAttribute("since"), e.getAttribute("until"), e.getAttribute("excludeFrom"));
    }

    public boolean isApplicable(VersionNumber v) {
        if (this.excludeVersions != null && (this.excludeVersions.contains(ALL_VERSION) || this.excludeVersions.contains(v))) {
            return false;
        }
        if (this.since != null && this.since.isNewerThan(v)) {
            return false;
        }
        return this.until == null || !v.isNewerThan(this.until);
    }
}

