/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.net.jsse;

import com.sun.grizzly.util.net.jsse.JSSEKeyManager;
import com.sun.grizzly.util.net.jsse.JSSESocketFactory;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class JSSE14SocketFactory
extends JSSESocketFactory {
    private static StringManager sm = StringManager.getManager("com.sun.grizzly.util.net.jsse.res");

    public void init() throws IOException {
        try {
            String algorithm;
            String protocol;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if (clientAuthStr != null) {
                this.clientAuth = Boolean.valueOf(clientAuthStr);
            }
            if ((protocol = (String)this.attributes.get("protocol")) == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            this.context = SSLContext.getInstance(protocol);
            this.configureSSLSessionContext(this.context.getServerSessionContext());
            this.context.init(this.getKeyManagers(algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(), new SecureRandom());
            this.sslProxy = this.context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore();
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (protocol.length() > 0) {
                        for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                            if (!supportedProtocols[i].equals(protocol)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            if (protocol != null && (protocol = protocol.trim()).length() > 0) {
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(protocol)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    private void configureSSLSessionContext(SSLSessionContext sslSessionCtxt) {
        String attrValue = (String)this.attributes.get("sslSessionTimeout");
        if (attrValue != null) {
            sslSessionCtxt.setSessionTimeout(Integer.valueOf(attrValue));
        }
        if ((attrValue = (String)this.attributes.get("ssl3SessionTimeout")) != null) {
            sslSessionCtxt.setSessionTimeout(Integer.valueOf(attrValue));
        }
        if ((attrValue = (String)this.attributes.get("sslSessionCacheSize")) != null) {
            sslSessionCtxt.setSessionCacheSize(Integer.valueOf(attrValue));
        }
    }
}

