/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.DocumentOrderingWrapper;
import com.sun.faces.config.FacesConfigInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.MetaInfFaceletTaglibraryConfigProvider;
import com.sun.faces.config.configprovider.MetaInfFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.MojarraFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.WebFaceletTaglibResourceProvider;
import com.sun.faces.config.configprovider.WebFacesConfigResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.BehaviorConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FaceletTaglibConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.AnnotationProviderFactory;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.ConfigurationResourceProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private static final List<ConfigurationResourceProvider> FACES_CONFIG_RESOURCE_PROVIDERS;
    private static final List<ConfigurationResourceProvider> FACELET_TAGLIBRARY_RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final ConfigManager CONFIG_MANAGER;
    private static final String ANNOTATIONS_SCAN_TASK_KEY;
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private static final ConfigProcessor FACES_CONFIG_PROCESSOR_CHAIN;
    private static final ConfigProcessor FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN;
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";

    public static ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public void initialize(ServletContext sc) {
        if (!this.hasBeenInitialized(sc)) {
            this.initializedContexts.add(sc);
            ExecutorService executor = null;
            try {
                WebConfiguration webConfig = WebConfiguration.getInstance(sc);
                boolean validating = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
                if (ConfigManager.useThreads(sc)) {
                    executor = ConfigManager.createExecutorService();
                }
                DocumentInfo[] facesDocuments = ConfigManager.getConfigDocuments(sc, this.getFacesConfigResourceProviders(), executor, validating);
                FacesConfigInfo webInfFacesConfigInfo = new FacesConfigInfo(facesDocuments[facesDocuments.length - 1]);
                facesDocuments = this.sortDocuments(facesDocuments, webInfFacesConfigInfo);
                boolean isFaceletsDisabled = this.isFaceletsDisabled(webConfig, webInfFacesConfigInfo);
                if (!webInfFacesConfigInfo.isWebInfFacesConfig() || !webInfFacesConfigInfo.isMetadataComplete()) {
                    Future<Map<Class<? extends Annotation>, Set<Class<?>>>> annotationScan;
                    Set<URL> scanUrls = ConfigManager.getAnnotationScanURLs(facesDocuments);
                    if (executor != null) {
                        annotationScan = executor.submit(new AnnotationScanTask(sc, scanUrls));
                        this.pushTaskToContext(sc, annotationScan);
                    } else {
                        annotationScan = new FutureTask(new AnnotationScanTask(sc, scanUrls));
                        ((FutureTask)annotationScan).run();
                    }
                    this.pushTaskToContext(sc, annotationScan);
                }
                FACES_CONFIG_PROCESSOR_CHAIN.process(sc, facesDocuments);
                if (!isFaceletsDisabled) {
                    FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN.process(sc, ConfigManager.getConfigDocuments(sc, this.getFaceletConfigResourceProviders(), executor, validating));
                }
                this.publishPostConfigEvent();
            }
            catch (Exception e) {
                this.releaseFactories();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unsanitized stacktrace from failed start...", e);
                }
                Throwable t = this.unwind(e);
                throw new ConfigurationException("CONFIGURATION FAILED! " + t.getMessage(), t);
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
                sc.removeAttribute(ANNOTATIONS_SCAN_TASK_KEY);
            }
        }
    }

    public void destroy(ServletContext sc) {
        this.releaseFactories();
        this.initializedContexts.remove(sc);
    }

    public boolean hasBeenInitialized(ServletContext sc) {
        return this.initializedContexts.contains(sc);
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(FacesContext ctx) {
        Map appMap = ctx.getExternalContext().getApplicationMap();
        Future scanTask = (Future)appMap.get(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return scanTask != null ? (Map)scanTask.get() : Collections.emptyMap();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static Set<URL> getAnnotationScanURLs(DocumentInfo[] documentInfos) {
        HashSet<URL> urls = new HashSet<URL>(documentInfos.length);
        HashSet<String> jarNames = new HashSet<String>(documentInfos.length);
        for (DocumentInfo docInfo : documentInfos) {
            FacesConfigInfo configInfo;
            String jarName;
            Matcher m = JAR_PATTERN.matcher(docInfo.getSourceURL().toString());
            if (!m.matches() || jarNames.contains(jarName = m.group(2)) || (configInfo = new FacesConfigInfo(docInfo)).isMetadataComplete()) continue;
            urls.add(docInfo.getSourceURL());
            jarNames.add(jarName);
        }
        return urls;
    }

    private static boolean useThreads(ServletContext ctx) {
        WebConfiguration config = WebConfiguration.getInstance(ctx);
        return config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private List<ConfigurationResourceProvider> getFacesConfigResourceProviders() {
        return this.getConfigurationResourceProviders(FACES_CONFIG_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FacesConfig);
    }

    private List<ConfigurationResourceProvider> getFaceletConfigResourceProviders() {
        return this.getConfigurationResourceProviders(FACELET_TAGLIBRARY_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FaceletConfig);
    }

    private List<ConfigurationResourceProvider> getConfigurationResourceProviders(List<ConfigurationResourceProvider> defaultProviders, ConfigurationResourceProviderFactory.ProviderType providerType) {
        ConfigurationResourceProvider[] custom = ConfigurationResourceProviderFactory.createProviders(providerType);
        if (custom.length == 0) {
            return defaultProviders;
        }
        ArrayList<ConfigurationResourceProvider> list = new ArrayList<ConfigurationResourceProvider>();
        list.addAll(defaultProviders);
        list.addAll(defaultProviders.size() - 1, Arrays.asList(custom));
        return Collections.unmodifiableList(list);
    }

    private DocumentInfo[] sortDocuments(DocumentInfo[] facesDocuments, FacesConfigInfo webInfFacesConfig) {
        int len = webInfFacesConfig.isWebInfFacesConfig() ? facesDocuments.length - 1 : facesDocuments.length;
        List<String> absoluteOrdering = webInfFacesConfig.getAbsoluteOrdering();
        if (len > 1) {
            ArrayList<DocumentOrderingWrapper> list = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < len; ++i) {
                list.add(new DocumentOrderingWrapper(facesDocuments[i]));
            }
            DocumentOrderingWrapper[] ordering = list.toArray(new DocumentOrderingWrapper[list.size()]);
            if (absoluteOrdering == null) {
                DocumentOrderingWrapper.sort(ordering);
                for (int i = 1; i < len; ++i) {
                    facesDocuments[i] = ordering[i - 1].getDocument();
                }
                return facesDocuments;
            }
            DocumentOrderingWrapper[] result = DocumentOrderingWrapper.sort(ordering, absoluteOrdering);
            DocumentInfo[] ret = new DocumentInfo[webInfFacesConfig.isWebInfFacesConfig() ? result.length + 2 : result.length + 1];
            for (int i = 1; i < len; ++i) {
                ret[i] = result[i - 1].getDocument();
            }
            ret[0] = facesDocuments[0];
            if (webInfFacesConfig.isWebInfFacesConfig()) {
                ret[ret.length - 1] = facesDocuments[facesDocuments.length - 1];
            }
            return ret;
        }
        return facesDocuments;
    }

    private boolean isFaceletsDisabled(WebConfiguration webconfig, FacesConfigInfo facesConfigInfo) {
        boolean isFaceletsDisabled = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (!isFaceletsDisabled) {
            isFaceletsDisabled = !facesConfigInfo.isVersionGreaterOrEqual(2.0);
            webconfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, isFaceletsDisabled);
        }
        return isFaceletsDisabled;
    }

    private void pushTaskToContext(ServletContext sc, Future<Map<Class<? extends Annotation>, Set<Class<?>>>> scanTask) {
        sc.setAttribute(ANNOTATIONS_SCAN_TASK_KEY, scanTask);
    }

    private void publishPostConfigEvent() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        app.publishEvent(ctx, PostConstructApplicationEvent.class, Application.class, (Object)app);
    }

    private static DocumentInfo[] getConfigDocuments(ServletContext sc, List<ConfigurationResourceProvider> providers, ExecutorService executor, boolean validating) {
        ArrayList<FutureTask> urlTasks = new ArrayList<FutureTask>(providers.size());
        for (ConfigurationResourceProvider p : providers) {
            FutureTask t = new FutureTask(new URLTask(p, sc));
            urlTasks.add(t);
            if (executor != null) {
                executor.execute(t);
                continue;
            }
            t.run();
        }
        ArrayList<FutureTask<DocumentInfo>> docTasks = new ArrayList<FutureTask<DocumentInfo>>(providers.size() << 1);
        for (FutureTask t : urlTasks) {
            try {
                Collection collection = (Collection)t.get();
                for (URL u : collection) {
                    FutureTask<DocumentInfo> d = new FutureTask<DocumentInfo>(new ParseTask(validating, u));
                    docTasks.add(d);
                    if (executor != null) {
                        executor.execute(d);
                        continue;
                    }
                    d.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList docs = new ArrayList(docTasks.size());
        for (FutureTask futureTask : docTasks) {
            try {
                docs.add(futureTask.get());
            }
            catch (ExecutionException e) {
                throw new ConfigurationException(e);
            }
            catch (InterruptedException ignored) {
            }
        }
        return docs.toArray(new DocumentInfo[docs.size()]);
    }

    private static ExecutorService createExecutorService() {
        int tc = Runtime.getRuntime().availableProcessors();
        if (tc > 5) {
            tc = 5;
        }
        return Executors.newFixedThreadPool(tc);
    }

    private Throwable unwind(Throwable throwable) {
        Throwable t = null;
        if (throwable != null && (t = this.unwind(throwable.getCause())) == null) {
            t = throwable;
        }
        return t;
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException ignored) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", ignored);
            }
        }
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        ANNOTATIONS_SCAN_TASK_KEY = ConfigManager.class.getName() + "_ANNOTATION_SCAN_TASK";
        ArrayList<ConfigurationResourceProvider> facesConfigProviders = new ArrayList<ConfigurationResourceProvider>(3);
        facesConfigProviders.add(new MojarraFacesConfigResourceProvider());
        facesConfigProviders.add(new MetaInfFacesConfigResourceProvider());
        facesConfigProviders.add(new WebFacesConfigResourceProvider());
        FACES_CONFIG_RESOURCE_PROVIDERS = Collections.unmodifiableList(facesConfigProviders);
        ArrayList<ConfigurationResourceProvider> faceletTaglibProviders = new ArrayList<ConfigurationResourceProvider>(3);
        faceletTaglibProviders.add(new MetaInfFaceletTaglibraryConfigProvider());
        faceletTaglibProviders.add(new WebFaceletTaglibResourceProvider());
        FACELET_TAGLIBRARY_RESOURCE_PROVIDERS = Collections.unmodifiableList(faceletTaglibProviders);
        ConfigProcessor[] configProcessors = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor(), new BehaviorConfigProcessor()};
        for (int i = 0; i < configProcessors.length; ++i) {
            ConfigProcessor p = configProcessors[i];
            if (i + 1 >= configProcessors.length) continue;
            p.setNext(configProcessors[i + 1]);
        }
        FACES_CONFIG_PROCESSOR_CHAIN = configProcessors[0];
        FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN = new FaceletTaglibConfigProcessor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLTask
    implements Callable<Collection<URL>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URLTask(ConfigurationResourceProvider provider, ServletContext sc) {
            this.provider = provider;
            this.sc = sc;
        }

        @Override
        public Collection<URL> call() throws Exception {
            List<URL> result = Collections.emptyList();
            Collection<URL> collection = this.provider.getResources(this.sc);
            if (!collection.isEmpty()) {
                result = new ArrayList<URL>();
                Iterator<URL> iter = collection.iterator();
                URL cur = iter.next();
                if (cur instanceof URL) {
                    do {
                        result.add(cur);
                    } while (null != (cur = iter.hasNext() ? iter.next() : null));
                } else if (cur instanceof URI) {
                    do {
                        result.add(((URI)((Object)cur)).toURL());
                    } while (null != (cur = iter.hasNext() ? iter.next() : null));
                } else {
                    throw new IllegalArgumentException("Expected argument of type URI or URL, instead type is " + cur.getClass().getName());
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<DocumentInfo> {
        private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private static final String EMPTY_FACES_CONFIG = "com/sun/faces/empty-faces-config.xml";
        private URL documentURL;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(boolean validating, URL documentURL) throws Exception {
            this.documentURL = documentURL;
            this.factory = DbfFactory.getFactory();
            this.validating = validating;
        }

        @Override
        public DocumentInfo call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document d = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURL.toExternalForm());
                }
                return new DocumentInfo(d, this.documentURL);
            }
            catch (Exception e) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURL.toExternalForm(), e.getMessage()), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Document getDocument() throws Exception {
            Document returnDoc;
            Document doc;
            block14: {
                DocumentBuilder db = this.getNonValidatingBuilder();
                InputSource is = new InputSource(ParseTask.getInputStream(this.documentURL));
                is.setSystemId(this.documentURL.toExternalForm());
                doc = null;
                try {
                    doc = db.parse(is);
                }
                catch (SAXParseException spe) {
                    InputStream stream = is.getByteStream();
                    stream.close();
                    is = new InputSource(ParseTask.getInputStream(this.documentURL));
                    stream = is.getByteStream();
                    if (!this.streamIsZeroLengthOrEmpty(stream) || !this.documentURL.toExternalForm().endsWith("faces-config.xml")) break block14;
                    ClassLoader loader = this.getClass().getClassLoader();
                    is = new InputSource(ParseTask.getInputStream(loader.getResource(EMPTY_FACES_CONFIG)));
                    doc = db.parse(is);
                }
            }
            String documentNS = doc.getDocumentElement().getNamespaceURI();
            if (this.validating && documentNS != null) {
                DOMSource domSource = new DOMSource(doc, this.documentURL.toExternalForm());
                Element documentElement = ((Document)domSource.getNode()).getDocumentElement();
                if (JAVAEE_SCHEMA_DEFAULT_NS.equals(documentNS)) {
                    DbfFactory.FacesSchema schema;
                    Attr version = (Attr)documentElement.getAttributes().getNamedItem("version");
                    if (version == null) throw new ConfigurationException("No document version available.");
                    String versionStr = version.getValue();
                    if ("2.0".equals(versionStr)) {
                        schema = "facelet-taglib".equals(documentElement.getLocalName()) ? DbfFactory.FacesSchema.FACELET_TAGLIB_20 : DbfFactory.FacesSchema.FACES_20;
                    } else {
                        if (!"1.2".equals(versionStr)) throw new ConfigurationException("Unknown Schema version: " + versionStr);
                        schema = DbfFactory.FacesSchema.FACES_12;
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schema);
                    if (builder.isValidating()) {
                        builder.getSchema().newValidator().validate(domSource);
                        returnDoc = (Document)domSource.getNode();
                    } else {
                        returnDoc = (Document)domSource.getNode();
                    }
                } else {
                    DbfFactory.FacesSchema schemaToApply;
                    DOMResult domResult = new DOMResult();
                    Transformer transformer = ParseTask.getTransformer(documentNS);
                    transformer.transform(domSource, domResult);
                    ((Document)domResult.getNode()).setDocumentURI(((Document)domSource.getNode()).getDocumentURI());
                    if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(documentNS)) {
                        schemaToApply = DbfFactory.FacesSchema.FACES_11;
                    } else {
                        if (!ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(documentNS)) throw new IllegalStateException();
                        schemaToApply = DbfFactory.FacesSchema.FACELET_TAGLIB_20;
                    }
                    DocumentBuilder builder = this.getBuilderForSchema(schemaToApply);
                    if (builder.isValidating()) {
                        builder.getSchema().newValidator().validate(new DOMSource(domResult.getNode()));
                        returnDoc = (Document)domResult.getNode();
                    } else {
                        returnDoc = (Document)domResult.getNode();
                    }
                }
            } else {
                returnDoc = doc;
            }
            if (!this.documentURL.toExternalForm().contains("/WEB-INF/faces-config.xml")) return returnDoc;
            Attr webInf = returnDoc.createAttribute(ConfigManager.WEB_INF_MARKER);
            webInf.setValue("true");
            returnDoc.getDocumentElement().getAttributes().setNamedItem(webInf);
            return returnDoc;
        }

        private boolean streamIsZeroLengthOrEmpty(InputStream is) throws IOException {
            boolean isZeroLengthOrEmpty = 0 == is.available();
            int size = 1024;
            byte[] b = new byte[1024];
            while (!isZeroLengthOrEmpty && -1 != is.read(b, 0, 1024)) {
                String s = new String(b).trim();
                isZeroLengthOrEmpty = 0 == s.length();
                b[0] = 0;
                for (int i = 1; i < 1024; i += i) {
                    System.arraycopy(b, 0, b, i, 1024 - i < i ? 1024 - i : i);
                }
            }
            return isZeroLengthOrEmpty;
        }

        private static Transformer getTransformer(String documentNS) throws Exception {
            String xslToApply;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(documentNS)) {
                xslToApply = ConfigManager.FACES_TO_1_1_PRIVATE_XSL;
            } else if (ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(documentNS)) {
                xslToApply = ConfigManager.FACELETS_TO_2_0_XSL;
            } else {
                throw new IllegalStateException();
            }
            return factory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(xslToApply))));
        }

        private static InputStream getInputStream(URL url) throws IOException {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return new BufferedInputStream(conn.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory tFactory = DbfFactory.getFactory();
            tFactory.setValidating(false);
            DocumentBuilder tBuilder = tFactory.newDocumentBuilder();
            tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return tBuilder;
        }

        private DocumentBuilder getBuilderForSchema(DbfFactory.FacesSchema schema) throws Exception {
            try {
                this.factory.setSchema(schema.getSchema());
            }
            catch (UnsupportedOperationException upe) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return builder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationScanTask
    implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private ServletContext sc;
        private Set<URL> urls;
        AnnotationProvider provider;

        public AnnotationScanTask(ServletContext sc, Set<URL> urls) {
            this.sc = sc;
            this.urls = urls;
            this.provider = AnnotationProviderFactory.createAnnotationProvider(sc);
        }

        @Override
        public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
            Timer t = Timer.getInstance();
            if (t != null) {
                t.startTiming();
            }
            Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = this.provider.getAnnotatedClasses(this.urls);
            if (t != null) {
                t.stopTiming();
                t.logResult("Configuration annotation scan complete.");
            }
            return annotatedClasses;
        }
    }
}

