/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j;

import com.sumologic.http.aggregation.SumoBufferFlusher;
import com.sumologic.http.queue.BufferWithEviction;
import com.sumologic.http.queue.BufferWithFifoEviction;
import com.sumologic.http.queue.CostBoundedConcurrentQueue;
import com.sumologic.http.sender.ProxySettings;
import com.sumologic.http.sender.SumoHttpSender;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="SumoLogicAppender", category="Core", elementType="appender", printObject=true)
public class SumoLogicAppender
extends AbstractAppender {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 1000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final int DEFAULT_RETRY_INTERVAL = 10000;
    private static final int DEFAULT_MAX_NUMBER_OF_RETRIES = -1;
    private static final int DEFAULT_MESSAGES_PER_REQUEST = 100;
    private static final long DEFAULT_MAX_FLUSH_INTERVAL = 10000L;
    private static final long DEFAULT_FLUSHING_ACCURACY = 250L;
    private static final long DEFAULT_MAX_QUEUE_SIZE_BYTES = 1000000L;
    private static final boolean FLUSH_ALL_MESSAGES_BEFORE_STOPPING = false;
    private static final String DEFAULT_RETRY_HTTP_CODE_REGEX = "^5.*";
    private SumoHttpSender sender;
    private SumoBufferFlusher flusher;
    private volatile BufferWithEviction<String> queue;
    private static final Logger logger = StatusLogger.getLogger();
    private static final String CLIENT_NAME = "log4j2-appender";

    protected SumoLogicAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String url, ProxySettings proxySettings, Integer retryInterval, Integer maxNumberOfRetries, Integer connectionTimeout, Integer socketTimeout, Integer messagesPerRequest, Long maxFlushInterval, String sourceName, String sourceCategory, String sourceHost, Long flushingAccuracy, Long maxQueueSizeBytes, Boolean flushAllBeforeStopping, String retryableHttpCodeRegex) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.queue = new BufferWithFifoEviction(maxQueueSizeBytes.longValue(), (CostBoundedConcurrentQueue.CostAssigner)new CostBoundedConcurrentQueue.CostAssigner<String>(){

            public long cost(String e) {
                return e.length();
            }
        });
        this.sender = new SumoHttpSender();
        this.sender.setRetryIntervalMs((long)retryInterval.intValue());
        this.sender.setMaxNumberOfRetries(maxNumberOfRetries.intValue());
        this.sender.setConnectionTimeoutMs(connectionTimeout.intValue());
        this.sender.setSocketTimeoutMs(socketTimeout.intValue());
        this.sender.setUrl(url);
        this.sender.setSourceName(sourceName);
        this.sender.setSourceCategory(sourceCategory);
        this.sender.setSourceHost(sourceHost);
        this.sender.setProxySettings(proxySettings);
        this.sender.setClientHeaderValue(CLIENT_NAME);
        this.sender.setRetryableHttpCodeRegex(retryableHttpCodeRegex);
        this.sender.init();
        this.flusher = new SumoBufferFlusher(flushingAccuracy.longValue(), messagesPerRequest.intValue(), maxFlushInterval.longValue(), this.sender, this.queue, flushAllBeforeStopping.booleanValue());
        this.flusher.start();
    }

    @PluginFactory
    @Deprecated
    public static SumoLogicAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="url") String url, @PluginAttribute(value="proxyAuth") String proxyAuth, @PluginAttribute(value="proxyHost") String proxyHost, @PluginAttribute(value="proxyPort") Integer proxyPort, @PluginAttribute(value="proxyUser") String proxyUser, @PluginAttribute(value="proxyPassword") String proxyPassword, @PluginAttribute(value="proxyDomain") String proxyDomain, @PluginAttribute(value="retryInterval", defaultInt=10000) Integer retryInterval, @PluginAttribute(value="maxNumberOfRetries", defaultInt=-1) Integer maxNumberOfRetries, @PluginAttribute(value="connectionTimeout", defaultInt=1000) Integer connectionTimeout, @PluginAttribute(value="socketTimeout", defaultInt=60000) Integer socketTimeout, @PluginAttribute(value="messagesPerRequest", defaultInt=100) Integer messagesPerRequest, @PluginAttribute(value="maxFlushInterval", defaultLong=10000L) Long maxFlushInterval, @PluginAttribute(value="sourceName") String sourceName, @PluginAttribute(value="sourceCategory") String sourceCategory, @PluginAttribute(value="sourceHost") String sourceHost, @PluginAttribute(value="flushingAccuracy", defaultLong=250L) Long flushingAccuracy, @PluginAttribute(value="maxQueueSizeBytes", defaultLong=1000000L) Long maxQueueSizeBytes, @PluginAttribute(value="flushAllBeforeStopping", defaultBoolean=false) Boolean flushAllBeforeStopping, @PluginAttribute(value="retryableHttpCodeRegex", defaultString="^5.*") String retryableHttpCodeRegex) {
        if (name == null) {
            logger.error("No name provided for SumoLogicAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (url == null) {
            logger.error("No url provided for SumoLogicAppender");
            return null;
        }
        ProxySettings proxySettings = new ProxySettings(proxyHost, proxyPort, proxyAuth, proxyUser, proxyPassword, proxyDomain);
        return new SumoLogicAppender(name, filter, (Layout<? extends Serializable>)layout, true, url, proxySettings, retryInterval, maxNumberOfRetries, connectionTimeout, socketTimeout, messagesPerRequest, maxFlushInterval, sourceName, sourceCategory, sourceHost, flushingAccuracy, maxQueueSizeBytes, flushAllBeforeStopping, retryableHttpCodeRegex);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void append(LogEvent event) {
        if (!this.checkEntryConditions()) {
            logger.warn("Appender not initialized. Dropping log entry");
            return;
        }
        String message = new String(this.getLayout().toByteArray(event));
        logger.debug("Sending message to Sumo: " + message);
        try {
            this.queue.add((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to insert log entry into log queue. ", (Throwable)e);
        }
    }

    public void setSourceName(String sourceName) {
        if (this.sender != null) {
            this.sender.setSourceName(sourceName);
        }
    }

    public void setSourceCategory(String sourceCategory) {
        if (this.sender != null) {
            this.sender.setSourceCategory(sourceCategory);
        }
    }

    public void setUrl(String url) {
        if (this.sender != null) {
            this.sender.setUrl(url);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        logger.debug("Stopping SumoLogicAppender {}", (Object)this.getName());
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        try {
            this.flusher.stop();
            logger.debug("flusher has been stopped");
            this.flusher = null;
            this.sender.close();
            this.sender = null;
        }
        catch (Exception e) {
            logger.error("Unable to close appender", (Throwable)e);
        }
        this.setStopped();
        logger.debug("SumoLogicAppender {} has been stopped", (Object)this.getName());
        return stopped;
    }

    private boolean checkEntryConditions() {
        return this.sender != null && this.sender.isInitialized();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<SumoLogicAppender> {
        @PluginBuilderAttribute
        @Required(message="Name is required for SumoLogicAppender")
        private String name;
        @PluginElement(value="layout")
        private Layout<? extends Serializable> layout;
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginBuilderAttribute
        @Required(message="Url is required for SumoLogicAppender")
        private String url;
        @PluginBuilderAttribute
        private String proxyAuth;
        @PluginBuilderAttribute
        private String proxyHost;
        @PluginBuilderAttribute
        private Integer proxyPort = 0;
        @PluginBuilderAttribute
        private String proxyUser;
        @PluginBuilderAttribute
        private String proxyPassword;
        @PluginBuilderAttribute
        private String proxyDomain;
        @PluginBuilderAttribute
        private int retryInterval = 10000;
        @PluginBuilderAttribute
        private int maxNumberOfRetries = -1;
        @PluginBuilderAttribute
        private int connectionTimeout = 1000;
        @PluginBuilderAttribute
        private int socketTimeout = 60000;
        @PluginBuilderAttribute
        private int messagesPerRequest = 100;
        @PluginBuilderAttribute
        private long maxFlushInterval = 10000L;
        @PluginBuilderAttribute
        private String sourceName;
        @PluginBuilderAttribute
        private String sourceCategory;
        @PluginBuilderAttribute
        private String sourceHost;
        @PluginBuilderAttribute
        private long flushingAccuracy = 250L;
        @PluginBuilderAttribute
        private long maxQueueSizeBytes = 1000000L;
        @PluginBuilderAttribute
        private boolean flushAllBeforeStopping = false;
        @PluginBuilderAttribute
        private String retryableHttpCodeRegex = "^5.*";

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLayout(Layout<? extends Serializable> layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setProxyAuth(String proxyAuth) {
            this.proxyAuth = proxyAuth;
            return this;
        }

        public Builder setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        public Builder setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder setProxyDomain(String proxyDomain) {
            this.proxyDomain = proxyDomain;
            return this;
        }

        public Builder setRetryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder setMaxNumberOfRetries(int maxNumberOfRetries) {
            this.maxNumberOfRetries = maxNumberOfRetries;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setMessagesPerRequest(int messagesPerRequest) {
            this.messagesPerRequest = messagesPerRequest;
            return this;
        }

        public Builder setMaxFlushInterval(long maxFlushInterval) {
            this.maxFlushInterval = maxFlushInterval;
            return this;
        }

        public Builder setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder setSourceCategory(String sourceCategory) {
            this.sourceCategory = sourceCategory;
            return this;
        }

        public Builder setSourceHost(String sourceHost) {
            this.sourceHost = sourceHost;
            return this;
        }

        public Builder setFlushingAccuracy(long flushingAccuracy) {
            this.flushingAccuracy = flushingAccuracy;
            return this;
        }

        public Builder setMaxQueueSizeBytes(long maxQueueSizeBytes) {
            this.maxQueueSizeBytes = maxQueueSizeBytes;
            return this;
        }

        public Builder setFlushAllBeforeStopping(boolean flushAllBeforeStopping) {
            this.flushAllBeforeStopping = flushAllBeforeStopping;
            return this;
        }

        public Builder setRetryableHttpCodeRegex(String retryableHttpCodeRegex) {
            this.retryableHttpCodeRegex = retryableHttpCodeRegex;
            return this;
        }

        public SumoLogicAppender build() {
            return SumoLogicAppender.createAppender(this.name, this.layout, this.filter, this.url, this.proxyAuth, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.proxyDomain, this.retryInterval, this.maxNumberOfRetries, this.connectionTimeout, this.socketTimeout, this.messagesPerRequest, this.maxFlushInterval, this.sourceName, this.sourceCategory, this.sourceHost, this.flushingAccuracy, this.maxQueueSizeBytes, this.flushAllBeforeStopping, this.retryableHttpCodeRegex);
        }
    }
}

