/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.http;

import com.sumologic.log4j.http.HttpProxySettingsCreator;
import com.sumologic.log4j.http.ProxySettings;
import java.io.IOException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class SumoHttpSender {
    private static final Logger logger = StatusLogger.getLogger();
    private static final String SUMO_SOURCE_NAME_HEADER = "X-Sumo-Name";
    private static final String SUMO_SOURCE_CATEGORY_HEADER = "X-Sumo-Category";
    private static final String SUMO_SOURCE_HOST_HEADER = "X-Sumo-Host";
    private static final String SUMO_CLIENT_HEADER = "X-Sumo-Client";
    private static final String SUMO_CLIENT_HEADER_VALUE = "log4j2-appender";
    private long retryInterval = 10000L;
    private int connectionTimeout = 1000;
    private int socketTimeout = 60000;
    private String url = null;
    private String sourceName = null;
    private String sourceCategory = null;
    private String sourceHost = null;
    private ProxySettings proxySettings = null;
    private CloseableHttpClient httpClient = null;

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceCategory(String sourceCategory) {
        this.sourceCategory = sourceCategory;
    }

    public void setSourceHost(String sourceHost) {
        this.sourceHost = sourceHost;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isInitialized() {
        return this.httpClient != null;
    }

    public void init() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectionTimeout).setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(requestConfig);
        HttpProxySettingsCreator creator = new HttpProxySettingsCreator(this.proxySettings);
        creator.configureProxySettings(builder);
        this.httpClient = builder.build();
    }

    public void close() throws IOException {
        this.httpClient.close();
        this.httpClient = null;
    }

    public void send(String body) {
        this.keepTrying(body);
    }

    private void keepTrying(String body) {
        boolean success = false;
        do {
            try {
                this.trySend(body);
                success = true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
        } while (!success && !Thread.currentThread().isInterrupted());
    }

    private void trySend(String body) throws IOException {
        HttpPost post = null;
        try {
            if (this.url == null) {
                throw new IOException("Unknown endpoint");
            }
            post = new HttpPost(this.url);
            this.safeSetHeader(post, SUMO_SOURCE_NAME_HEADER, this.sourceName);
            this.safeSetHeader(post, SUMO_SOURCE_CATEGORY_HEADER, this.sourceCategory);
            this.safeSetHeader(post, SUMO_SOURCE_HOST_HEADER, this.sourceHost);
            this.safeSetHeader(post, SUMO_CLIENT_HEADER, SUMO_CLIENT_HEADER_VALUE);
            post.setEntity((HttpEntity)new StringEntity(body, Consts.UTF_8));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.warn(String.format("Received HTTP error from Sumo Service: %d", statusCode));
                if (statusCode == 503) {
                    throw new IOException("Server unavailable");
                }
            }
            logger.debug("Successfully sent log request to Sumo Logic");
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            logger.warn("Could not send log to Sumo Logic");
            logger.debug("Reason:", (Throwable)e);
            try {
                post.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void safeSetHeader(HttpPost post, String name, String value) {
        if (value != null && !value.trim().isEmpty()) {
            post.setHeader(name, value);
        }
    }
}

