/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.image;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.stripe.android.uicore.image.ImageType;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"getResourceId", "Lkotlin/Pair;", "Landroid/content/res/Resources;", "", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getDrawableFromUri", "Landroid/graphics/drawable/Drawable;", "isSupportedImageUrl", "", "", "TAG", "stripe-ui-core_release"})
@SourceDebugExtension(value={"SMAP\nUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiUtils.kt\ncom/stripe/android/uicore/image/UiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1755#2,2:125\n1755#2,3:127\n1757#2:130\n*S KotlinDebug\n*F\n+ 1 UiUtils.kt\ncom/stripe/android/uicore/image/UiUtilsKt\n*L\n86#1:125,2\n87#1:127,3\n86#1:130\n*E\n"})
public final class UiUtilsKt {
    @NotNull
    private static final String TAG = "stripe_ui_core_utils";

    @SuppressLint(value={"DiscouragedApi"})
    @NotNull
    public static final Pair<Resources, Integer> getResourceId(@NotNull Context $this$getResourceId, @NotNull Uri uri) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getResourceId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!(!TextUtils.isEmpty((CharSequence)uri.getAuthority()))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = uri.getAuthority();
        if (string3 == null) {
            String string4 = "Required value was null.";
            throw new IllegalArgumentException(string4.toString());
        }
        String authority = string3;
        Resources resources = $this$getResourceId.getPackageManager().getResourcesForApplication(authority);
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResourcesForApplication(...)");
        Resources r = resources;
        List list = uri.getPathSegments();
        if (list == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        List path = list;
        switch (path.size()) {
            case 1: {
                int n2;
                try {
                    n2 = Integer.parseInt((String)path.get(0));
                }
                catch (NumberFormatException e) {
                    throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
                }
                n = n2;
                break;
            }
            case 2: {
                n = r.getIdentifier((String)path.get(1), (String)path.get(0), authority);
                break;
            }
            default: {
                throw new FileNotFoundException("More than two path segments: " + uri);
            }
        }
        int id = n;
        if (id == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        return TuplesKt.to((Object)r, (Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final Drawable getDrawableFromUri(@NotNull Context $this$getDrawableFromUri, @NotNull Uri uri) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableFromUri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String scheme = uri.getScheme();
        if (Intrinsics.areEqual((Object)"android.resource", (Object)scheme)) {
            try {
                Pair<Resources, Integer> pair = UiUtilsKt.getResourceId($this$getDrawableFromUri, uri);
                Resources resource = (Resources)pair.component1();
                int id = ((Number)pair.component2()).intValue();
                return resource.getDrawable(id, $this$getDrawableFromUri.getTheme());
            }
            catch (Resources.NotFoundException e) {
                n = Log.e((String)TAG, (String)("Unable to open content: " + uri), (Throwable)e);
            }
        } else if (Intrinsics.areEqual((Object)"content", (Object)scheme) || Intrinsics.areEqual((Object)"file", (Object)scheme)) {
            try {
                Closeable closeable = $this$getDrawableFromUri.getContentResolver().openInputStream(uri);
                Throwable e = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Drawable drawable2 = Drawable.createFromStream((InputStream)it, (String)uri.toString());
                    return drawable2;
                }
                catch (Throwable throwable) {
                    e = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)e);
                }
            }
            catch (IOException e) {
                n = Log.w((String)TAG, (String)("Unable to open content: " + uri), (Throwable)e);
            }
        } else {
            return Drawable.createFromPath((String)uri.toString());
        }
        return null;
    }

    public static final boolean isSupportedImageUrl(@NotNull String $this$isSupportedImageUrl) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$isSupportedImageUrl, (String)"<this>");
            Iterable $this$any$iv = (Iterable)ImageType.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        ImageType imageType = (ImageType)((Object)element$iv);
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = imageType.getSuffixes();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String suffix = (String)element$iv2;
                                boolean bl4 = false;
                                if (!StringsKt.endsWith((String)$this$isSupportedImageUrl, (String)suffix, (boolean)true)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }
}

