/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.image;

import android.util.LruCache;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.uicore.image.ImageLruMemoryCache;
import com.stripe.android.uicore.image.LoadedImage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\t\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u000eJ\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\f\u0012\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/uicore/image/ImageLruMemoryCache;", "", "maxSize", "", "<init>", "(I)V", "getMaxSize", "()I", "lruCache", "com/stripe/android/uicore/image/ImageLruMemoryCache$lruCache$1", "getLruCache$annotations", "()V", "Lcom/stripe/android/uicore/image/ImageLruMemoryCache$lruCache$1;", "put", "", "key", "", "image", "Lcom/stripe/android/uicore/image/LoadedImage;", "get", "clear", "toKey", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
public final class ImageLruMemoryCache {
    private final int maxSize;
    @NotNull
    private final lruCache.1 lruCache;
    public static final int $stable;

    public ImageLruMemoryCache(int maxSize) {
        int n = this.maxSize = maxSize;
        this.lruCache = new LruCache<String, LoadedImage>(n){

            protected int sizeOf(String key, LoadedImage image) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                return image.getBitmap().getByteCount() / 1024;
            }
        };
    }

    public /* synthetic */ ImageLruMemoryCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = (int)(Runtime.getRuntime().maxMemory() / (long)1024) / 8;
        }
        this(n);
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    private static /* synthetic */ void getLruCache$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull String key, @NotNull LoadedImage image) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ImageLruMemoryCache imageLruMemoryCache = this;
        synchronized (imageLruMemoryCache) {
            boolean bl = false;
            if (this.lruCache.get(this.toKey(key)) == null) {
                this.lruCache.put(this.toKey(key), image);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LoadedImage get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ImageLruMemoryCache imageLruMemoryCache = this;
        synchronized (imageLruMemoryCache) {
            boolean bl = false;
            LoadedImage loadedImage = (LoadedImage)this.lruCache.get(this.toKey(key));
            return loadedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ImageLruMemoryCache imageLruMemoryCache = this;
        synchronized (imageLruMemoryCache) {
            boolean bl = false;
            this.lruCache.evictAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String toKey(String $this$toKey) {
        return String.valueOf($this$toKey.hashCode());
    }

    public ImageLruMemoryCache() {
        this(0, 1, null);
    }
}

