/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.format;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/uicore/format/CurrencyFormatter;", "", "<init>", "()V", "MAJOR_UNIT_BASE", "", "SERVER_DECIMAL_DIGITS", "", "", "", "", "format", "amount", "", "amountCurrencyCode", "targetLocale", "Ljava/util/Locale;", "amountCurrency", "Ljava/util/Currency;", "getDefaultDecimalDigits", "currency", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCurrencyFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrencyFormatter.kt\ncom/stripe/android/uicore/format/CurrencyFormatter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,86:1\n535#2:87\n520#2,6:88\n126#3:94\n153#3,3:95\n*S KotlinDebug\n*F\n+ 1 CurrencyFormatter.kt\ncom/stripe/android/uicore/format/CurrencyFormatter\n*L\n79#1:87\n79#1:88,6\n81#1:94\n81#1:95,3\n*E\n"})
public final class CurrencyFormatter {
    @NotNull
    public static final CurrencyFormatter INSTANCE = new CurrencyFormatter();
    private static final double MAJOR_UNIT_BASE = 10.0;
    @NotNull
    private static final Map<Set<String>, Integer> SERVER_DECIMAL_DIGITS;
    public static final int $stable;

    private CurrencyFormatter() {
    }

    @NotNull
    public final String format(long amount, @NotNull String amountCurrencyCode, @NotNull Locale targetLocale) {
        Intrinsics.checkNotNullParameter((Object)amountCurrencyCode, (String)"amountCurrencyCode");
        Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
        String string2 = amountCurrencyCode.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        Currency currency = Currency.getInstance(string2);
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(...)");
        return this.format(amount, currency, targetLocale);
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l, String string2, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            locale = Locale.getDefault();
        }
        return currencyFormatter.format(l, string2, locale);
    }

    @NotNull
    public final String format(long amount, @NotNull Currency amountCurrency, @NotNull Locale targetLocale) {
        Intrinsics.checkNotNullParameter((Object)amountCurrency, (String)"amountCurrency");
        Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
        int amountCurrencyDecimalDigits = this.getDefaultDecimalDigits(amountCurrency);
        double majorUnitAmount = (double)amount / Math.pow(10.0, amountCurrencyDecimalDigits);
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(targetLocale);
        CurrencyFormatter currencyFormatter = this;
        try {
            CurrencyFormatter $this$format_u24lambda_u240 = currencyFormatter;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrency(amountCurrency);
            decimalFormatSymbols.setCurrencySymbol(amountCurrency.getSymbol(targetLocale));
            ((DecimalFormat)currencyFormat).setMinimumFractionDigits(amountCurrencyDecimalDigits);
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String string2 = currencyFormat.format(majorUnitAmount);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l, Currency currency, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            locale = Locale.getDefault();
        }
        return currencyFormatter.format(l, currency, locale);
    }

    /*
     * WARNING - void declaration
     */
    public final int getDefaultDecimalDigits(@NotNull Currency currency) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Map<Set<String>, Integer> $this$filter$iv = SERVER_DECIMAL_DIGITS;
        boolean $i$f$filter = false;
        Map<Set<String>, Integer> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Set set = (Set)entry.getKey();
            String string2 = currency.getCurrencyCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCurrencyCode(...)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            if (!set.contains(string3)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)it.getValue()).intValue());
        }
        Integer n = (Integer)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return n != null ? n.intValue() : currency.getDefaultFractionDigits();
    }

    static {
        Object[] objectArray = new String[]{"UGX", "AFN", "ALL", "AMD", "COP", "IDR", "ISK", "PKR", "LBP", "MMK", "LAK", "RSD"};
        SERVER_DECIMAL_DIGITS = MapsKt.mapOf((Pair)TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)2));
        $stable = 8;
    }
}

