/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.uicore.elements;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.autofill.AutofillType;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.VisualTransformation;
import androidx.compose.ui.unit.LayoutDirection;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.uicore.elements.DateConfig;
import com.stripe.android.uicore.elements.EmailConfig;
import com.stripe.android.uicore.elements.FieldError;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.NameConfig;
import com.stripe.android.uicore.elements.PostalCodeConfig;
import com.stripe.android.uicore.elements.SectionFieldElement;
import com.stripe.android.uicore.elements.TextFieldConfig;
import com.stripe.android.uicore.elements.TextFieldController;
import com.stripe.android.uicore.elements.TextFieldIcon;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import com.stripe.android.uicore.elements.TextFieldUIKt;
import com.stripe.android.uicore.forms.FormFieldEntry;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001BL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012%\b\u0002\u0010\b\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010O\u001a\u0004\u0018\u00010@2\u0006\u0010P\u001a\u00020\u0007H\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0016J\u0010\u0010T\u001a\u00020R2\u0006\u0010U\u001a\u00020\u0005H\u0016JO\u0010V\u001a\u00020R2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\b\u0010_\u001a\u0004\u0018\u00010^2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020aH\u0017\u00a2\u0006\u0004\bc\u0010dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R+\u0010\b\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\"\u0010\u001eR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001aR\u001c\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0015R\u0016\u0010-\u001a\u0004\u0018\u00010.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u000102X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u00104\u001a\u0004\b5\u00106R\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00070'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001aR\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001aR\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u001aR\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020@0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020@0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001aR\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001aR\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u001aR\u001c\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010I0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u001aR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u001aR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u001a\u00a8\u0006e"}, d2={"Lcom/stripe/android/uicore/elements/SimpleTextFieldController;", "Lcom/stripe/android/uicore/elements/TextFieldController;", "textFieldConfig", "Lcom/stripe/android/uicore/elements/TextFieldConfig;", "showOptionalLabel", "", "initialValue", "", "overrideContentDescriptionProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "fieldValue", "Lcom/stripe/android/core/strings/ResolvableString;", "<init>", "(Lcom/stripe/android/uicore/elements/TextFieldConfig;ZLjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getTextFieldConfig", "()Lcom/stripe/android/uicore/elements/TextFieldConfig;", "getShowOptionalLabel", "()Z", "getInitialValue", "()Ljava/lang/String;", "trailingIcon", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/uicore/elements/TextFieldIcon;", "getTrailingIcon", "()Lkotlinx/coroutines/flow/StateFlow;", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "keyboardType", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboardType-PjHm6EE", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "label", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getLabel", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "debugLabel", "getDebugLabel", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "autofillType", "Landroidx/compose/ui/autofill/AutofillType;", "getAutofillType$annotations", "()V", "getAutofillType", "()Landroidx/compose/ui/autofill/AutofillType;", "placeHolder", "getPlaceHolder", "_fieldValue", "getFieldValue", "rawFieldValue", "getRawFieldValue", "contentDescription", "getContentDescription", "_fieldState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "fieldState", "getFieldState", "loading", "getLoading", "_hasFocus", "visibleError", "getVisibleError", "error", "Lcom/stripe/android/uicore/elements/FieldError;", "getError", "isComplete", "formFieldValue", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "getFormFieldValue", "onValueChange", "displayFormatted", "onRawValueChange", "", "rawValue", "onFocusChange", "newHasFocus", "ComposeUI", "enabled", "field", "Lcom/stripe/android/uicore/elements/SectionFieldElement;", "modifier", "Landroidx/compose/ui/Modifier;", "hiddenIdentifiers", "", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "lastTextFieldIdentifier", "nextFocusDirection", "Landroidx/compose/ui/focus/FocusDirection;", "previousFocusDirection", "ComposeUI-MxjM1cc", "(ZLcom/stripe/android/uicore/elements/SectionFieldElement;Landroidx/compose/ui/Modifier;Ljava/util/Set;Lcom/stripe/android/uicore/elements/IdentifierSpec;IILandroidx/compose/runtime/Composer;I)V", "stripe-ui-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextFieldController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldController.kt\ncom/stripe/android/uicore/elements/SimpleTextFieldController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1#2:252\n*E\n"})
public final class SimpleTextFieldController
implements TextFieldController {
    @NotNull
    private final TextFieldConfig textFieldConfig;
    private final boolean showOptionalLabel;
    @Nullable
    private final String initialValue;
    @Nullable
    private final Function1<String, ResolvableString> overrideContentDescriptionProvider;
    @NotNull
    private final StateFlow<TextFieldIcon> trailingIcon;
    private final int capitalization;
    private final int keyboardType;
    @NotNull
    private final StateFlow<VisualTransformation> visualTransformation;
    @NotNull
    private final MutableStateFlow<Integer> label;
    @NotNull
    private final String debugLabel;
    @Nullable
    private final LayoutDirection layoutDirection;
    @Nullable
    private final AutofillType autofillType;
    @NotNull
    private final MutableStateFlow<String> placeHolder;
    @NotNull
    private final MutableStateFlow<String> _fieldValue;
    @NotNull
    private final StateFlow<String> fieldValue;
    @NotNull
    private final StateFlow<String> rawFieldValue;
    @NotNull
    private final StateFlow<ResolvableString> contentDescription;
    @NotNull
    private final MutableStateFlow<TextFieldState> _fieldState;
    @NotNull
    private final StateFlow<TextFieldState> fieldState;
    @NotNull
    private final StateFlow<Boolean> loading;
    @NotNull
    private final MutableStateFlow<Boolean> _hasFocus;
    @NotNull
    private final StateFlow<Boolean> visibleError;
    @NotNull
    private final StateFlow<FieldError> error;
    @NotNull
    private final StateFlow<Boolean> isComplete;
    @NotNull
    private final StateFlow<FormFieldEntry> formFieldValue;
    public static final int $stable = 8;

    public SimpleTextFieldController(@NotNull TextFieldConfig textFieldConfig, boolean showOptionalLabel, @Nullable String initialValue, @Nullable Function1<? super String, ? extends ResolvableString> overrideContentDescriptionProvider) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)textFieldConfig, (String)"textFieldConfig");
            this.textFieldConfig = textFieldConfig;
            this.showOptionalLabel = showOptionalLabel;
            this.initialValue = initialValue;
            this.overrideContentDescriptionProvider = overrideContentDescriptionProvider;
            this.trailingIcon = this.textFieldConfig.getTrailingIcon();
            this.capitalization = this.textFieldConfig.getCapitalization-IUNYP9k();
            this.keyboardType = this.textFieldConfig.getKeyboard-PjHm6EE();
            VisualTransformation visualTransformation2 = this.textFieldConfig.getVisualTransformation();
            if (visualTransformation2 == null) {
                visualTransformation2 = VisualTransformation.Companion.getNone();
            }
            this.visualTransformation = StateFlowsKt.stateFlowOf(visualTransformation2);
            this.label = StateFlowKt.MutableStateFlow((Object)this.textFieldConfig.getLabel());
            this.debugLabel = this.textFieldConfig.getDebugLabel();
            this.layoutDirection = this.textFieldConfig.getLayoutDirection();
            TextFieldConfig textFieldConfig2 = this.textFieldConfig;
            this.autofillType = textFieldConfig2 instanceof DateConfig ? AutofillType.CreditCardExpirationDate : (textFieldConfig2 instanceof PostalCodeConfig ? AutofillType.PostalCode : (textFieldConfig2 instanceof EmailConfig ? AutofillType.EmailAddress : (textFieldConfig2 instanceof NameConfig ? AutofillType.PersonFullName : null)));
            this.placeHolder = StateFlowKt.MutableStateFlow((Object)this.textFieldConfig.getPlaceHolder());
            this._fieldValue = StateFlowKt.MutableStateFlow((Object)"");
            this.fieldValue = FlowKt.asStateFlow(this._fieldValue);
            this.rawFieldValue = StateFlowsKt.mapAsStateFlow((StateFlow)this._fieldValue, arg_0 -> SimpleTextFieldController.rawFieldValue$lambda$0(this, arg_0));
            this.contentDescription = StateFlowsKt.mapAsStateFlow((StateFlow)this._fieldValue, arg_0 -> SimpleTextFieldController.contentDescription$lambda$1(this, arg_0));
            this._fieldState = StateFlowKt.MutableStateFlow((Object)TextFieldStateConstants.Error.Blank.INSTANCE);
            this.fieldState = FlowKt.asStateFlow(this._fieldState);
            this.loading = this.textFieldConfig.getLoading();
            this._hasFocus = StateFlowKt.MutableStateFlow((Object)false);
            this.visibleError = StateFlowsKt.combineAsStateFlow((StateFlow)this._fieldState, (StateFlow)this._hasFocus, SimpleTextFieldController::visibleError$lambda$2);
            this.error = StateFlowsKt.mapAsStateFlow(this.getVisibleError(), arg_0 -> SimpleTextFieldController.error$lambda$4(this, arg_0));
            this.isComplete = StateFlowsKt.mapAsStateFlow((StateFlow)this._fieldState, arg_0 -> SimpleTextFieldController.isComplete$lambda$5(this, arg_0));
            this.formFieldValue = StateFlowsKt.combineAsStateFlow(this.isComplete(), this.getRawFieldValue(), SimpleTextFieldController::formFieldValue$lambda$6);
            String string2 = this.getInitialValue();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            this.onRawValueChange(it);
        }
    }

    public /* synthetic */ SimpleTextFieldController(TextFieldConfig textFieldConfig, boolean bl, String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(textFieldConfig, bl, string2, (Function1<? super String, ? extends ResolvableString>)function1);
    }

    @NotNull
    public final TextFieldConfig getTextFieldConfig() {
        return this.textFieldConfig;
    }

    @Override
    public boolean getShowOptionalLabel() {
        return this.showOptionalLabel;
    }

    @Override
    @Nullable
    public String getInitialValue() {
        return this.initialValue;
    }

    @Override
    @NotNull
    public StateFlow<TextFieldIcon> getTrailingIcon() {
        return this.trailingIcon;
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    public int getKeyboardType-PjHm6EE() {
        return this.keyboardType;
    }

    @Override
    @NotNull
    public StateFlow<VisualTransformation> getVisualTransformation() {
        return this.visualTransformation;
    }

    @NotNull
    public MutableStateFlow<Integer> getLabel() {
        return this.label;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    @Nullable
    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @Override
    @Nullable
    public AutofillType getAutofillType() {
        return this.autofillType;
    }

    public static /* synthetic */ void getAutofillType$annotations() {
    }

    @NotNull
    public MutableStateFlow<String> getPlaceHolder() {
        return this.placeHolder;
    }

    @Override
    @NotNull
    public StateFlow<String> getFieldValue() {
        return this.fieldValue;
    }

    @Override
    @NotNull
    public StateFlow<String> getRawFieldValue() {
        return this.rawFieldValue;
    }

    @Override
    @NotNull
    public StateFlow<ResolvableString> getContentDescription() {
        return this.contentDescription;
    }

    @Override
    @NotNull
    public StateFlow<TextFieldState> getFieldState() {
        return this.fieldState;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getLoading() {
        return this.loading;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> getVisibleError() {
        return this.visibleError;
    }

    @Override
    @NotNull
    public StateFlow<FieldError> getError() {
        return this.error;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isComplete() {
        return this.isComplete;
    }

    @Override
    @NotNull
    public StateFlow<FormFieldEntry> getFormFieldValue() {
        return this.formFieldValue;
    }

    @Override
    @Nullable
    public TextFieldState onValueChange(@NotNull String displayFormatted) {
        Intrinsics.checkNotNullParameter((Object)displayFormatted, (String)"displayFormatted");
        TextFieldState originalTextStateValue = (TextFieldState)this._fieldState.getValue();
        this._fieldValue.setValue((Object)this.textFieldConfig.filter(displayFormatted));
        this._fieldState.setValue((Object)this.textFieldConfig.determineState((String)this._fieldValue.getValue()));
        return !Intrinsics.areEqual((Object)this._fieldState.getValue(), (Object)originalTextStateValue) ? (TextFieldState)this._fieldState.getValue() : null;
    }

    @Override
    public void onRawValueChange(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        this.onValueChange(this.textFieldConfig.convertFromRaw(rawValue));
    }

    @Override
    public void onFocusChange(boolean newHasFocus) {
        this._hasFocus.setValue((Object)newHasFocus);
    }

    @Override
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public void ComposeUI-MxjM1cc(boolean enabled, @NotNull SectionFieldElement field, @NotNull Modifier modifier, @NotNull Set<IdentifierSpec> hiddenIdentifiers, @Nullable IdentifierSpec lastTextFieldIdentifier, int nextFocusDirection, int previousFocusDirection, @Nullable Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter(hiddenIdentifiers, (String)"hiddenIdentifiers");
        $composer.startReplaceableGroup(154759369);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)154759369, (int)$changed, (int)-1, (String)"com.stripe.android.uicore.elements.SimpleTextFieldController.ComposeUI (TextFieldController.kt:233)");
        }
        TextFieldUIKt.TextField-ZkbtPhE(this, enabled, Intrinsics.areEqual((Object)lastTextFieldIdentifier, (Object)field.getIdentifier()) ? ImeAction.Companion.getDone-eUduSuo() : ImeAction.Companion.getNext-eUduSuo(), modifier, null, nextFocusDirection, previousFocusDirection, null, this.textFieldConfig.getShouldAnnounceLabel(), this.textFieldConfig.getShouldAnnounceFieldValue(), $composer, 0xE & $changed >> 21 | 0x70 & $changed << 3 | 0x1C00 & $changed << 3 | 0x70000 & $changed | 0x380000 & $changed, 144);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
    }

    @Override
    public void onDropdownItemClicked(@NotNull TextFieldIcon.Dropdown.Item item) {
        TextFieldController.DefaultImpls.onDropdownItemClicked(this, item);
    }

    @Override
    public boolean getEnabled() {
        return TextFieldController.DefaultImpls.getEnabled(this);
    }

    private static final String rawFieldValue$lambda$0(SimpleTextFieldController this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.textFieldConfig.convertToRaw(it);
    }

    private static final ResolvableString contentDescription$lambda$1(SimpleTextFieldController this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResolvableString resolvableString = this$0.overrideContentDescriptionProvider;
        if (resolvableString == null || (resolvableString = (ResolvableString)resolvableString.invoke((Object)it)) == null) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((String)it);
        }
        return resolvableString;
    }

    private static final boolean visibleError$lambda$2(TextFieldState fieldState, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)fieldState, (String)"fieldState");
        return fieldState.shouldShowError(hasFocus);
    }

    private static final FieldError error$lambda$4(SimpleTextFieldController this$0, boolean visibleError) {
        FieldError fieldError;
        FieldError fieldError2 = ((TextFieldState)this$0._fieldState.getValue()).getError();
        if (fieldError2 != null) {
            FieldError fieldError3;
            FieldError it = fieldError3 = fieldError2;
            boolean bl = false;
            fieldError = visibleError ? fieldError3 : null;
        } else {
            fieldError = null;
        }
        return fieldError;
    }

    private static final boolean isComplete$lambda$5(SimpleTextFieldController this$0, TextFieldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid() || !it.isValid() && this$0.getShowOptionalLabel() && it.isBlank();
    }

    private static final FormFieldEntry formFieldValue$lambda$6(boolean complete, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new FormFieldEntry(value, complete);
    }
}

