// File generated from our OpenAPI spec
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter
@EqualsAndHashCode(callSuper = false)
public class SubscriptionMigrateParams extends ApiRequestParams {
  /**
   * <strong>Required.</strong> Controls how prorations and invoices for subscriptions are
   * calculated and orchestrated.
   */
  @SerializedName("billing_mode")
  BillingMode billingMode;

  /** Specifies which fields in the response should be expanded. */
  @SerializedName("expand")
  List<String> expand;

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;

  private SubscriptionMigrateParams(
      BillingMode billingMode, List<String> expand, Map<String, Object> extraParams) {
    this.billingMode = billingMode;
    this.expand = expand;
    this.extraParams = extraParams;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private BillingMode billingMode;

    private List<String> expand;

    private Map<String, Object> extraParams;

    /** Finalize and obtain parameter instance from this builder. */
    public SubscriptionMigrateParams build() {
      return new SubscriptionMigrateParams(this.billingMode, this.expand, this.extraParams);
    }

    /**
     * <strong>Required.</strong> Controls how prorations and invoices for subscriptions are
     * calculated and orchestrated.
     */
    public Builder setBillingMode(SubscriptionMigrateParams.BillingMode billingMode) {
      this.billingMode = billingMode;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionMigrateParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * SubscriptionMigrateParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * SubscriptionMigrateParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link SubscriptionMigrateParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }
  }

  @Getter
  @EqualsAndHashCode(callSuper = false)
  public static class BillingMode {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;

    /** Configure behavior for flexible billing mode. */
    @SerializedName("flexible")
    Flexible flexible;

    /**
     * <strong>Required.</strong> Controls the calculation and orchestration of prorations and
     * invoices for subscriptions.
     */
    @SerializedName("type")
    Type type;

    private BillingMode(Map<String, Object> extraParams, Flexible flexible, Type type) {
      this.extraParams = extraParams;
      this.flexible = flexible;
      this.type = type;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static class Builder {
      private Map<String, Object> extraParams;

      private Flexible flexible;

      private Type type;

      /** Finalize and obtain parameter instance from this builder. */
      public SubscriptionMigrateParams.BillingMode build() {
        return new SubscriptionMigrateParams.BillingMode(
            this.extraParams, this.flexible, this.type);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * SubscriptionMigrateParams.BillingMode#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link SubscriptionMigrateParams.BillingMode#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** Configure behavior for flexible billing mode. */
      public Builder setFlexible(SubscriptionMigrateParams.BillingMode.Flexible flexible) {
        this.flexible = flexible;
        return this;
      }

      /**
       * <strong>Required.</strong> Controls the calculation and orchestration of prorations and
       * invoices for subscriptions.
       */
      public Builder setType(SubscriptionMigrateParams.BillingMode.Type type) {
        this.type = type;
        return this;
      }
    }

    @Getter
    @EqualsAndHashCode(callSuper = false)
    public static class Flexible {
      /**
       * Map of extra parameters for custom features not available in this client library. The
       * content in this map is not serialized under this field's {@code @SerializedName} value.
       * Instead, each key/value pair is serialized as if the key is a root-level field (serialized)
       * name in this param object. Effectively, this map is flattened to its parent instance.
       */
      @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
      Map<String, Object> extraParams;

      /** Controls how invoices and invoice items display proration amounts and discount amounts. */
      @SerializedName("proration_discounts")
      ProrationDiscounts prorationDiscounts;

      private Flexible(Map<String, Object> extraParams, ProrationDiscounts prorationDiscounts) {
        this.extraParams = extraParams;
        this.prorationDiscounts = prorationDiscounts;
      }

      public static Builder builder() {
        return new Builder();
      }

      public static class Builder {
        private Map<String, Object> extraParams;

        private ProrationDiscounts prorationDiscounts;

        /** Finalize and obtain parameter instance from this builder. */
        public SubscriptionMigrateParams.BillingMode.Flexible build() {
          return new SubscriptionMigrateParams.BillingMode.Flexible(
              this.extraParams, this.prorationDiscounts);
        }

        /**
         * Add a key/value pair to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link SubscriptionMigrateParams.BillingMode.Flexible#extraParams} for the field
         * documentation.
         */
        public Builder putExtraParam(String key, Object value) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.put(key, value);
          return this;
        }

        /**
         * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
         * `put/putAll` call, and subsequent calls add additional key/value pairs to the original
         * map. See {@link SubscriptionMigrateParams.BillingMode.Flexible#extraParams} for the field
         * documentation.
         */
        public Builder putAllExtraParam(Map<String, Object> map) {
          if (this.extraParams == null) {
            this.extraParams = new HashMap<>();
          }
          this.extraParams.putAll(map);
          return this;
        }

        /**
         * Controls how invoices and invoice items display proration amounts and discount amounts.
         */
        public Builder setProrationDiscounts(
            SubscriptionMigrateParams.BillingMode.Flexible.ProrationDiscounts prorationDiscounts) {
          this.prorationDiscounts = prorationDiscounts;
          return this;
        }
      }

      public enum ProrationDiscounts implements ApiRequestParams.EnumParam {
        @SerializedName("included")
        INCLUDED("included"),

        @SerializedName("itemized")
        ITEMIZED("itemized");

        @Getter(onMethod_ = {@Override})
        private final String value;

        ProrationDiscounts(String value) {
          this.value = value;
        }
      }
    }

    public enum Type implements ApiRequestParams.EnumParam {
      @SerializedName("flexible")
      FLEXIBLE("flexible");

      @Getter(onMethod_ = {@Override})
      private final String value;

      Type(String value) {
        this.value = value;
      }
    }
  }
}
