// File generated from our OpenAPI spec
package com.stripe.model.v2.core;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.v2.EventDataClassLookup;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.time.Instant;
import java.util.Map;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * Events are generated to keep you informed of activity in your business account. APIs in the /v2
 * namespace generate <a
 * href="https://docs.stripe.com/event-destinations#benefits-of-thin-events">thin events</a> which
 * have small, unversioned payloads that include a reference to the ID of the object that has
 * changed. The Events v2 API returns these new thin events. <a
 * href="https://docs.stripe.com/event-destinations#fetch-data">Retrieve the event object</a> for
 * additional data about the event. Use the related object ID in the event payload to <a
 * href="https://docs.stripe.com/event-destinations#retrieve-the-object-associated-with-thin-events">fetch
 * the API resource</a> of the object associated with the event. Comparatively, events generated by
 * most API v1 include a versioned snapshot of an API object in their payload.
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class Event extends StripeObject implements HasId, StripeActiveObject {
  /** Before and after changes for the primary related object. */
  @SerializedName("changes")
  Map<String, Object> changes;

  /** Authentication context needed to fetch the event or related object. */
  @SerializedName("context")
  String context;

  /** Time at which the object was created. */
  @SerializedName("created")
  Instant created;

  /** Unique identifier for the event. */
  @Getter(onMethod_ = {@Override})
  @SerializedName("id")
  String id;

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;

  /**
   * String representing the object's type. Objects of the same type share the same value of the
   * object field.
   *
   * <p>Equal to {@code v2.core.event}.
   */
  @SerializedName("object")
  String object;

  /** Reason for the event. */
  @SerializedName("reason")
  Reason reason;

  /** The type of the event. */
  @SerializedName("type")
  String type;

  StripeResponseGetter responseGetter;

  @Override
  public void setResponseGetter(StripeResponseGetter responseGetter) {
    this.responseGetter = responseGetter;
  }

  /** Retrieves the object associated with the event. */
  protected StripeObject fetchRelatedObject(RelatedObject relatedObject) throws StripeException {
    if (relatedObject == null) {
      return null;
    }
    if (relatedObject.getUrl() == null) {
      return null;
    }

    Class<? extends StripeObject> objectClass =
        EventDataClassLookup.classLookup.get(relatedObject.getType());
    if (objectClass == null) {
      objectClass = StripeRawJsonObject.class;
    }

    RequestOptions opts = null;

    if (context != null) {
      opts = new RequestOptions.RequestOptionsBuilder().setStripeAccount(context).build();
    }

    return this.responseGetter.request(
        new ApiRequest(
            BaseAddress.API, ApiResource.RequestMethod.GET, relatedObject.getUrl(), null, opts),
        objectClass);
  }

  /**
   * Returns an StripeEvent instance using the provided JSON payload. Throws a JsonSyntaxException
   * if the payload is not valid JSON.
   *
   * @param payload the payload sent by Stripe.
   * @return the StripeEvent instance
   */
  public static Event parse(String payload) {
    return ApiResource.GSON.fromJson(payload, Event.class);
  }

  @Getter
  @Setter
  @EqualsAndHashCode(callSuper = false)
  public static class RelatedObject extends StripeObject implements HasId {
    /** Unique identifier for the object relevant to the event. */
    @Getter(onMethod_ = {@Override})
    @SerializedName("id")
    String id;

    /** Type of the object relevant to the event. */
    @SerializedName("type")
    String type;

    /** Type of the object relevant to the event. */
    @SerializedName("url")
    String url;
  }

  /** Reason for the event. */
  @Getter
  @Setter
  @EqualsAndHashCode(callSuper = false)
  public static class Reason extends StripeObject {
    /** Information on the API request that instigated the event. */
    @SerializedName("request")
    Request request;

    /**
     * Event reason type.
     *
     * <p>Equal to {@code request}.
     */
    @SerializedName("type")
    String type;

    /** Information on the API request that instigated the event. */
    @Getter
    @Setter
    @EqualsAndHashCode(callSuper = false)
    public static class Request extends StripeObject implements HasId {
      /** ID of the API request that caused the event. */
      @Getter(onMethod_ = {@Override})
      @SerializedName("id")
      String id;

      /** The idempotency key transmitted during the request. */
      @SerializedName("idempotency_key")
      String idempotencyKey;
    }
  }
}
