/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.Price;
import com.stripe.model.StripeObject;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.model.TaxRate;
import com.stripe.model.UsageRecordSummaryCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SubscriptionItemCreateParams;
import com.stripe.param.SubscriptionItemDeleteParams;
import com.stripe.param.SubscriptionItemListParams;
import com.stripe.param.SubscriptionItemRetrieveParams;
import com.stripe.param.SubscriptionItemUpdateParams;
import com.stripe.param.SubscriptionItemUsageRecordSummariesParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class SubscriptionItem
extends ApiResource
implements HasId,
MetadataStore<SubscriptionItem> {
    @SerializedName(value="billing_thresholds")
    BillingThresholds billingThresholds;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="plan")
    Plan plan;
    @SerializedName(value="price")
    Price price;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="subscription")
    String subscription;
    @SerializedName(value="tax_rates")
    List<TaxRate> taxRates;

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public static SubscriptionItem create(Map<String, Object> params) throws StripeException {
        return SubscriptionItem.create(params, (RequestOptions)null);
    }

    public static SubscriptionItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionItem)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public static SubscriptionItem create(SubscriptionItemCreateParams params) throws StripeException {
        return SubscriptionItem.create(params, (RequestOptions)null);
    }

    public static SubscriptionItem create(SubscriptionItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem delete() throws StripeException {
        return this.delete((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionItem delete(RequestOptions options) throws StripeException {
        return this.delete((Map<String, Object>)null, options);
    }

    public SubscriptionItem delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public SubscriptionItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (SubscriptionItem)this.getResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem delete(SubscriptionItemDeleteParams params) throws StripeException {
        return this.delete(params, (RequestOptions)null);
    }

    public SubscriptionItem delete(SubscriptionItemDeleteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.getResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public static SubscriptionItemCollection list(Map<String, Object> params) throws StripeException {
        return SubscriptionItem.list(params, (RequestOptions)null);
    }

    public static SubscriptionItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (SubscriptionItemCollection)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItemCollection.class));
    }

    public static SubscriptionItemCollection list(SubscriptionItemListParams params) throws StripeException {
        return SubscriptionItem.list(params, (RequestOptions)null);
    }

    public static SubscriptionItemCollection list(SubscriptionItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_items";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItemCollection)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItemCollection.class));
    }

    public static SubscriptionItem retrieve(String item) throws StripeException {
        return SubscriptionItem.retrieve(item, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SubscriptionItem retrieve(String item, RequestOptions options) throws StripeException {
        return SubscriptionItem.retrieve(item, (Map<String, Object>)null, options);
    }

    public static SubscriptionItem retrieve(String item, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (SubscriptionItem)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public static SubscriptionItem retrieve(String item, SubscriptionItemRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(item));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)SubscriptionItem.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SubscriptionItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionItem)this.getResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public SubscriptionItem update(SubscriptionItemUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SubscriptionItem update(SubscriptionItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionItem)this.getResponseGetter().request(request, (Type)((Object)SubscriptionItem.class));
    }

    public UsageRecordSummaryCollection usageRecordSummaries() throws StripeException {
        return this.usageRecordSummaries((Map<String, Object>)null, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params) throws StripeException {
        return this.usageRecordSummaries(params, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (UsageRecordSummaryCollection)this.getResponseGetter().request(request, (Type)((Object)UsageRecordSummaryCollection.class));
    }

    public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params) throws StripeException {
        return this.usageRecordSummaries(params, (RequestOptions)null);
    }

    public UsageRecordSummaryCollection usageRecordSummaries(SubscriptionItemUsageRecordSummariesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_items/%s/usage_record_summaries", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (UsageRecordSummaryCollection)this.getResponseGetter().request(request, (Type)((Object)UsageRecordSummaryCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.billingThresholds, responseGetter);
        this.trySetResponseGetter(this.plan, responseGetter);
        this.trySetResponseGetter(this.price, responseGetter);
    }

    @Generated
    public BillingThresholds getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Price getPrice() {
        return this.price;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getSubscription() {
        return this.subscription;
    }

    @Generated
    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    @Generated
    public void setBillingThresholds(BillingThresholds billingThresholds) {
        this.billingThresholds = billingThresholds;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setPrice(Price price) {
        this.price = price;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Generated
    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionItem)) {
            return false;
        }
        SubscriptionItem other = (SubscriptionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        BillingThresholds this$billingThresholds = this.getBillingThresholds();
        BillingThresholds other$billingThresholds = other.getBillingThresholds();
        if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Price this$price = this.getPrice();
        Price other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        List<TaxRate> this$taxRates = this.getTaxRates();
        List<TaxRate> other$taxRates = other.getTaxRates();
        return !(this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        BillingThresholds $billingThresholds = this.getBillingThresholds();
        result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Price $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        List<TaxRate> $taxRates = this.getTaxRates();
        result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BillingThresholds
    extends StripeObject {
        @SerializedName(value="usage_gte")
        Long usageGte;

        @Generated
        public Long getUsageGte() {
            return this.usageGte;
        }

        @Generated
        public void setUsageGte(Long usageGte) {
            this.usageGte = usageGte;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingThresholds)) {
                return false;
            }
            BillingThresholds other = (BillingThresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$usageGte = this.getUsageGte();
            Long other$usageGte = other.getUsageGte();
            return !(this$usageGte == null ? other$usageGte != null : !((Object)this$usageGte).equals(other$usageGte));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingThresholds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $usageGte = this.getUsageGte();
            result = result * 59 + ($usageGte == null ? 43 : ((Object)$usageGte).hashCode());
            return result;
        }
    }
}

