/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.billing.MeterCollection;
import com.stripe.model.billing.MeterEventSummaryCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.MeterCreateParams;
import com.stripe.param.billing.MeterDeactivateParams;
import com.stripe.param.billing.MeterEventSummariesParams;
import com.stripe.param.billing.MeterListParams;
import com.stripe.param.billing.MeterReactivateParams;
import com.stripe.param.billing.MeterRetrieveParams;
import com.stripe.param.billing.MeterUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Meter
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer_mapping")
    CustomerMapping customerMapping;
    @SerializedName(value="default_aggregation")
    DefaultAggregation defaultAggregation;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="event_name")
    String eventName;
    @SerializedName(value="event_time_window")
    String eventTimeWindow;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="updated")
    Long updated;
    @SerializedName(value="value_settings")
    ValueSettings valueSettings;

    public static Meter create(Map<String, Object> params) throws StripeException {
        return Meter.create(params, (RequestOptions)null);
    }

    public static Meter create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Meter)Meter.getGlobalResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public static Meter create(MeterCreateParams params) throws StripeException {
        return Meter.create(params, (RequestOptions)null);
    }

    public static Meter create(MeterCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Meter)Meter.getGlobalResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public Meter deactivate() throws StripeException {
        return this.deactivate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Meter deactivate(RequestOptions options) throws StripeException {
        return this.deactivate((Map<String, Object>)null, options);
    }

    public Meter deactivate(Map<String, Object> params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Meter deactivate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public Meter deactivate(MeterDeactivateParams params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Meter deactivate(MeterDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public MeterEventSummaryCollection eventSummaries(Map<String, Object> params) throws StripeException {
        return this.eventSummaries(params, (RequestOptions)null);
    }

    public MeterEventSummaryCollection eventSummaries(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/event_summaries", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (MeterEventSummaryCollection)this.getResponseGetter().request(request, (Type)((Object)MeterEventSummaryCollection.class));
    }

    public MeterEventSummaryCollection eventSummaries(MeterEventSummariesParams params) throws StripeException {
        return this.eventSummaries(params, (RequestOptions)null);
    }

    public MeterEventSummaryCollection eventSummaries(MeterEventSummariesParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/event_summaries", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (MeterEventSummaryCollection)this.getResponseGetter().request(request, (Type)((Object)MeterEventSummaryCollection.class));
    }

    public static MeterCollection list(Map<String, Object> params) throws StripeException {
        return Meter.list(params, (RequestOptions)null);
    }

    public static MeterCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (MeterCollection)Meter.getGlobalResponseGetter().request(request, (Type)((Object)MeterCollection.class));
    }

    public static MeterCollection list(MeterListParams params) throws StripeException {
        return Meter.list(params, (RequestOptions)null);
    }

    public static MeterCollection list(MeterListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/meters";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (MeterCollection)Meter.getGlobalResponseGetter().request(request, (Type)((Object)MeterCollection.class));
    }

    public Meter reactivate() throws StripeException {
        return this.reactivate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Meter reactivate(RequestOptions options) throws StripeException {
        return this.reactivate((Map<String, Object>)null, options);
    }

    public Meter reactivate(Map<String, Object> params) throws StripeException {
        return this.reactivate(params, (RequestOptions)null);
    }

    public Meter reactivate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/reactivate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public Meter reactivate(MeterReactivateParams params) throws StripeException {
        return this.reactivate(params, (RequestOptions)null);
    }

    public Meter reactivate(MeterReactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/reactivate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public static Meter retrieve(String id) throws StripeException {
        return Meter.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Meter retrieve(String id, RequestOptions options) throws StripeException {
        return Meter.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Meter retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Meter)Meter.getGlobalResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public static Meter retrieve(String id, MeterRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Meter)Meter.getGlobalResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public Meter update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Meter update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    public Meter update(MeterUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Meter update(MeterUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Meter)this.getResponseGetter().request(request, (Type)((Object)Meter.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.customerMapping, responseGetter);
        this.trySetResponseGetter(this.defaultAggregation, responseGetter);
        this.trySetResponseGetter(this.statusTransitions, responseGetter);
        this.trySetResponseGetter(this.valueSettings, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CustomerMapping getCustomerMapping() {
        return this.customerMapping;
    }

    @Generated
    public DefaultAggregation getDefaultAggregation() {
        return this.defaultAggregation;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @Generated
    public String getEventTimeWindow() {
        return this.eventTimeWindow;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public ValueSettings getValueSettings() {
        return this.valueSettings;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCustomerMapping(CustomerMapping customerMapping) {
        this.customerMapping = customerMapping;
    }

    @Generated
    public void setDefaultAggregation(DefaultAggregation defaultAggregation) {
        this.defaultAggregation = defaultAggregation;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Generated
    public void setEventTimeWindow(String eventTimeWindow) {
        this.eventTimeWindow = eventTimeWindow;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public void setValueSettings(ValueSettings valueSettings) {
        this.valueSettings = valueSettings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Meter)) {
            return false;
        }
        Meter other = (Meter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        CustomerMapping this$customerMapping = this.getCustomerMapping();
        CustomerMapping other$customerMapping = other.getCustomerMapping();
        if (this$customerMapping == null ? other$customerMapping != null : !((Object)this$customerMapping).equals(other$customerMapping)) {
            return false;
        }
        DefaultAggregation this$defaultAggregation = this.getDefaultAggregation();
        DefaultAggregation other$defaultAggregation = other.getDefaultAggregation();
        if (this$defaultAggregation == null ? other$defaultAggregation != null : !((Object)this$defaultAggregation).equals(other$defaultAggregation)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        String this$eventTimeWindow = this.getEventTimeWindow();
        String other$eventTimeWindow = other.getEventTimeWindow();
        if (this$eventTimeWindow == null ? other$eventTimeWindow != null : !this$eventTimeWindow.equals(other$eventTimeWindow)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        ValueSettings this$valueSettings = this.getValueSettings();
        ValueSettings other$valueSettings = other.getValueSettings();
        return !(this$valueSettings == null ? other$valueSettings != null : !((Object)this$valueSettings).equals(other$valueSettings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Meter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        CustomerMapping $customerMapping = this.getCustomerMapping();
        result = result * 59 + ($customerMapping == null ? 43 : ((Object)$customerMapping).hashCode());
        DefaultAggregation $defaultAggregation = this.getDefaultAggregation();
        result = result * 59 + ($defaultAggregation == null ? 43 : ((Object)$defaultAggregation).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        String $eventTimeWindow = this.getEventTimeWindow();
        result = result * 59 + ($eventTimeWindow == null ? 43 : $eventTimeWindow.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        ValueSettings $valueSettings = this.getValueSettings();
        result = result * 59 + ($valueSettings == null ? 43 : ((Object)$valueSettings).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CustomerMapping
    extends StripeObject {
        @SerializedName(value="event_payload_key")
        String eventPayloadKey;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getEventPayloadKey() {
            return this.eventPayloadKey;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setEventPayloadKey(String eventPayloadKey) {
            this.eventPayloadKey = eventPayloadKey;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerMapping)) {
                return false;
            }
            CustomerMapping other = (CustomerMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$eventPayloadKey = this.getEventPayloadKey();
            String other$eventPayloadKey = other.getEventPayloadKey();
            if (this$eventPayloadKey == null ? other$eventPayloadKey != null : !this$eventPayloadKey.equals(other$eventPayloadKey)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerMapping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $eventPayloadKey = this.getEventPayloadKey();
            result = result * 59 + ($eventPayloadKey == null ? 43 : $eventPayloadKey.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class DefaultAggregation
    extends StripeObject {
        @SerializedName(value="formula")
        String formula;

        @Generated
        public String getFormula() {
            return this.formula;
        }

        @Generated
        public void setFormula(String formula) {
            this.formula = formula;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultAggregation)) {
                return false;
            }
            DefaultAggregation other = (DefaultAggregation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$formula = this.getFormula();
            String other$formula = other.getFormula();
            return !(this$formula == null ? other$formula != null : !this$formula.equals(other$formula));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultAggregation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $formula = this.getFormula();
            result = result * 59 + ($formula == null ? 43 : $formula.hashCode());
            return result;
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="deactivated_at")
        Long deactivatedAt;

        @Generated
        public Long getDeactivatedAt() {
            return this.deactivatedAt;
        }

        @Generated
        public void setDeactivatedAt(Long deactivatedAt) {
            this.deactivatedAt = deactivatedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$deactivatedAt = this.getDeactivatedAt();
            Long other$deactivatedAt = other.getDeactivatedAt();
            return !(this$deactivatedAt == null ? other$deactivatedAt != null : !((Object)this$deactivatedAt).equals(other$deactivatedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $deactivatedAt = this.getDeactivatedAt();
            result = result * 59 + ($deactivatedAt == null ? 43 : ((Object)$deactivatedAt).hashCode());
            return result;
        }
    }

    public static class ValueSettings
    extends StripeObject {
        @SerializedName(value="event_payload_key")
        String eventPayloadKey;

        @Generated
        public String getEventPayloadKey() {
            return this.eventPayloadKey;
        }

        @Generated
        public void setEventPayloadKey(String eventPayloadKey) {
            this.eventPayloadKey = eventPayloadKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueSettings)) {
                return false;
            }
            ValueSettings other = (ValueSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$eventPayloadKey = this.getEventPayloadKey();
            String other$eventPayloadKey = other.getEventPayloadKey();
            return !(this$eventPayloadKey == null ? other$eventPayloadKey != null : !this$eventPayloadKey.equals(other$eventPayloadKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ValueSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $eventPayloadKey = this.getEventPayloadKey();
            result = result * 59 + ($eventPayloadKey == null ? 43 : $eventPayloadKey.hashCode());
            return result;
        }
    }
}

