/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.TransactionListParams;
import com.stripe.param.treasury.TransactionRetrieveParams;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Transaction> list(TransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Transaction> list(TransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Transaction>>(){}.getType());
    }

    public Transaction retrieve(String id, TransactionRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Transaction retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Transaction retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Transaction retrieve(String id, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }
}

