/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.stripe.exception.StripeException;
import com.stripe.model.treasury.FinancialAccountFeatures;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.FinancialAccountFeaturesRetrieveParams;
import com.stripe.param.treasury.FinancialAccountFeaturesUpdateParams;
import java.lang.reflect.Type;

public final class FinancialAccountFeaturesService
extends ApiService {
    public FinancialAccountFeaturesService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public FinancialAccountFeatures update(String financialAccount, FinancialAccountFeaturesUpdateParams params) throws StripeException {
        return this.update(financialAccount, params, null);
    }

    public FinancialAccountFeatures update(String financialAccount, RequestOptions options) throws StripeException {
        return this.update(financialAccount, null, options);
    }

    public FinancialAccountFeatures update(String financialAccount) throws StripeException {
        return this.update(financialAccount, null, null);
    }

    public FinancialAccountFeatures update(String financialAccount, FinancialAccountFeaturesUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(financialAccount));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FinancialAccountFeatures)this.request(request, (Type)((Object)FinancialAccountFeatures.class));
    }

    public FinancialAccountFeatures retrieve(String financialAccount, FinancialAccountFeaturesRetrieveParams params) throws StripeException {
        return this.retrieve(financialAccount, params, null);
    }

    public FinancialAccountFeatures retrieve(String financialAccount, RequestOptions options) throws StripeException {
        return this.retrieve(financialAccount, null, options);
    }

    public FinancialAccountFeatures retrieve(String financialAccount) throws StripeException {
        return this.retrieve(financialAccount, null, null);
    }

    public FinancialAccountFeatures retrieve(String financialAccount, FinancialAccountFeaturesRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(financialAccount));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FinancialAccountFeatures)this.request(request, (Type)((Object)FinancialAccountFeatures.class));
    }
}

