/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountCreateParams;
import com.stripe.param.AccountListParams;
import com.stripe.param.AccountRejectParams;
import com.stripe.param.AccountRetrieveCurrentParams;
import com.stripe.param.AccountRetrieveParams;
import com.stripe.param.AccountUpdateParams;
import com.stripe.service.AccountCapabilityService;
import com.stripe.service.AccountExternalAccountService;
import com.stripe.service.AccountLoginLinkService;
import com.stripe.service.AccountPersonService;
import java.lang.reflect.Type;

public final class AccountService
extends ApiService {
    public AccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Account delete(String account) throws StripeException {
        return this.delete(account, null);
    }

    public Account delete(String account, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account retrieve(String account, AccountRetrieveParams params) throws StripeException {
        return this.retrieve(account, params, null);
    }

    public Account retrieve(String account, RequestOptions options) throws StripeException {
        return this.retrieve(account, null, options);
    }

    public Account retrieve(String account) throws StripeException {
        return this.retrieve(account, null, null);
    }

    public Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account update(String account, AccountUpdateParams params) throws StripeException {
        return this.update(account, params, null);
    }

    public Account update(String account, RequestOptions options) throws StripeException {
        return this.update(account, null, options);
    }

    public Account update(String account) throws StripeException {
        return this.update(account, null, null);
    }

    public Account update(String account, AccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account retrieveCurrent(AccountRetrieveCurrentParams params) throws StripeException {
        return this.retrieveCurrent(params, null);
    }

    public Account retrieveCurrent(RequestOptions options) throws StripeException {
        return this.retrieveCurrent(null, options);
    }

    public Account retrieveCurrent() throws StripeException {
        return this.retrieveCurrent(null, null);
    }

    public Account retrieveCurrent(AccountRetrieveCurrentParams params, RequestOptions options) throws StripeException {
        String path = "/v1/account";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public StripeCollection<Account> list(AccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Account> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Account> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Account> list(AccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Account>>(){}.getType());
    }

    public Account create(AccountCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Account create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Account create() throws StripeException {
        return this.create(null, null);
    }

    public Account create(AccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account reject(String account, AccountRejectParams params) throws StripeException {
        return this.reject(account, params, null);
    }

    public Account reject(String account, AccountRejectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public AccountCapabilityService capabilities() {
        return new AccountCapabilityService(this.getResponseGetter());
    }

    public AccountExternalAccountService externalAccounts() {
        return new AccountExternalAccountService(this.getResponseGetter());
    }

    public AccountLoginLinkService loginLinks() {
        return new AccountLoginLinkService(this.getResponseGetter());
    }

    public AccountPersonService persons() {
        return new AccountPersonService(this.getResponseGetter());
    }
}

