/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CalculationCreateParams
extends ApiRequestParams {
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_details")
    CustomerDetails customerDetails;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="ship_from_details")
    ShipFromDetails shipFromDetails;
    @SerializedName(value="shipping_cost")
    ShippingCost shippingCost;
    @SerializedName(value="tax_date")
    Long taxDate;

    private CalculationCreateParams(String currency, String customer, CustomerDetails customerDetails, List<String> expand, Map<String, Object> extraParams, List<LineItem> lineItems, ShipFromDetails shipFromDetails, ShippingCost shippingCost, Long taxDate) {
        this.currency = currency;
        this.customer = customer;
        this.customerDetails = customerDetails;
        this.expand = expand;
        this.extraParams = extraParams;
        this.lineItems = lineItems;
        this.shipFromDetails = shipFromDetails;
        this.shippingCost = shippingCost;
        this.taxDate = taxDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerDetails getCustomerDetails() {
        return this.customerDetails;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public ShipFromDetails getShipFromDetails() {
        return this.shipFromDetails;
    }

    @Generated
    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    @Generated
    public Long getTaxDate() {
        return this.taxDate;
    }

    public static class CustomerDetails {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="address_source")
        AddressSource addressSource;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="ip_address")
        String ipAddress;
        @SerializedName(value="tax_ids")
        List<TaxId> taxIds;
        @SerializedName(value="taxability_override")
        TaxabilityOverride taxabilityOverride;

        private CustomerDetails(Address address, AddressSource addressSource, Map<String, Object> extraParams, String ipAddress, List<TaxId> taxIds, TaxabilityOverride taxabilityOverride) {
            this.address = address;
            this.addressSource = addressSource;
            this.extraParams = extraParams;
            this.ipAddress = ipAddress;
            this.taxIds = taxIds;
            this.taxabilityOverride = taxabilityOverride;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public AddressSource getAddressSource() {
            return this.addressSource;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public List<TaxId> getTaxIds() {
            return this.taxIds;
        }

        @Generated
        public TaxabilityOverride getTaxabilityOverride() {
            return this.taxabilityOverride;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, String country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            public static class Builder {
                private Object city;
                private String country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static enum AddressSource implements ApiRequestParams.EnumParam
        {
            BILLING("billing"),
            SHIPPING("shipping");

            private final String value;

            private AddressSource(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum TaxabilityOverride implements ApiRequestParams.EnumParam
        {
            CUSTOMER_EXEMPT("customer_exempt"),
            NONE("none"),
            REVERSE_CHARGE("reverse_charge");

            private final String value;

            private TaxabilityOverride(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Address address;
            private AddressSource addressSource;
            private Map<String, Object> extraParams;
            private String ipAddress;
            private List<TaxId> taxIds;
            private TaxabilityOverride taxabilityOverride;

            public CustomerDetails build() {
                return new CustomerDetails(this.address, this.addressSource, this.extraParams, this.ipAddress, this.taxIds, this.taxabilityOverride);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setAddressSource(AddressSource addressSource) {
                this.addressSource = addressSource;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIpAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public Builder addTaxId(TaxId element) {
                if (this.taxIds == null) {
                    this.taxIds = new ArrayList<TaxId>();
                }
                this.taxIds.add(element);
                return this;
            }

            public Builder addAllTaxId(List<TaxId> elements) {
                if (this.taxIds == null) {
                    this.taxIds = new ArrayList<TaxId>();
                }
                this.taxIds.addAll(elements);
                return this;
            }

            public Builder setTaxabilityOverride(TaxabilityOverride taxabilityOverride) {
                this.taxabilityOverride = taxabilityOverride;
                return this;
            }
        }

        public static class TaxId {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="type")
            Type type;
            @SerializedName(value="value")
            String value;

            private TaxId(Map<String, Object> extraParams, Type type, String value) {
                this.extraParams = extraParams;
                this.type = type;
                this.value = value;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                AD_NRT("ad_nrt"),
                AE_TRN("ae_trn"),
                AR_CUIT("ar_cuit"),
                AU_ABN("au_abn"),
                AU_ARN("au_arn"),
                BG_UIC("bg_uic"),
                BH_VAT("bh_vat"),
                BO_TIN("bo_tin"),
                BR_CNPJ("br_cnpj"),
                BR_CPF("br_cpf"),
                CA_BN("ca_bn"),
                CA_GST_HST("ca_gst_hst"),
                CA_PST_BC("ca_pst_bc"),
                CA_PST_MB("ca_pst_mb"),
                CA_PST_SK("ca_pst_sk"),
                CA_QST("ca_qst"),
                CH_VAT("ch_vat"),
                CL_TIN("cl_tin"),
                CN_TIN("cn_tin"),
                CO_NIT("co_nit"),
                CR_TIN("cr_tin"),
                DO_RCN("do_rcn"),
                EC_RUC("ec_ruc"),
                EG_TIN("eg_tin"),
                ES_CIF("es_cif"),
                EU_OSS_VAT("eu_oss_vat"),
                EU_VAT("eu_vat"),
                GB_VAT("gb_vat"),
                GE_VAT("ge_vat"),
                HK_BR("hk_br"),
                HU_TIN("hu_tin"),
                ID_NPWP("id_npwp"),
                IL_VAT("il_vat"),
                IN_GST("in_gst"),
                IS_VAT("is_vat"),
                JP_CN("jp_cn"),
                JP_RN("jp_rn"),
                JP_TRN("jp_trn"),
                KE_PIN("ke_pin"),
                KR_BRN("kr_brn"),
                KZ_BIN("kz_bin"),
                LI_UID("li_uid"),
                MX_RFC("mx_rfc"),
                MY_FRP("my_frp"),
                MY_ITN("my_itn"),
                MY_SST("my_sst"),
                NG_TIN("ng_tin"),
                NO_VAT("no_vat"),
                NO_VOEC("no_voec"),
                NZ_GST("nz_gst"),
                OM_VAT("om_vat"),
                PE_RUC("pe_ruc"),
                PH_TIN("ph_tin"),
                RO_TIN("ro_tin"),
                RS_PIB("rs_pib"),
                RU_INN("ru_inn"),
                RU_KPP("ru_kpp"),
                SA_VAT("sa_vat"),
                SG_GST("sg_gst"),
                SG_UEN("sg_uen"),
                SI_TIN("si_tin"),
                SV_NIT("sv_nit"),
                TH_VAT("th_vat"),
                TR_TIN("tr_tin"),
                TW_VAT("tw_vat"),
                UA_VAT("ua_vat"),
                US_EIN("us_ein"),
                UY_RUC("uy_ruc"),
                VE_RIF("ve_rif"),
                VN_TIN("vn_tin"),
                ZA_VAT("za_vat");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Type type;
                private String value;

                public TaxId build() {
                    return new TaxId(this.extraParams, this.type, this.value);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }

                public Builder setValue(String value) {
                    this.value = value;
                    return this;
                }
            }
        }
    }

    public static class ShipFromDetails {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private ShipFromDetails(Address address, Map<String, Object> extraParams) {
            this.address = address;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, String country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            public static class Builder {
                private Object city;
                private String country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private Map<String, Object> extraParams;

            public ShipFromDetails build() {
                return new ShipFromDetails(this.address, this.extraParams);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class ShippingCost {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="shipping_rate")
        String shippingRate;
        @SerializedName(value="tax_behavior")
        TaxBehavior taxBehavior;
        @SerializedName(value="tax_code")
        String taxCode;

        private ShippingCost(Long amount, Map<String, Object> extraParams, String shippingRate, TaxBehavior taxBehavior, String taxCode) {
            this.amount = amount;
            this.extraParams = extraParams;
            this.shippingRate = shippingRate;
            this.taxBehavior = taxBehavior;
            this.taxCode = taxCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getShippingRate() {
            return this.shippingRate;
        }

        @Generated
        public TaxBehavior getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        public static enum TaxBehavior implements ApiRequestParams.EnumParam
        {
            EXCLUSIVE("exclusive"),
            INCLUSIVE("inclusive");

            private final String value;

            private TaxBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;
            private String shippingRate;
            private TaxBehavior taxBehavior;
            private String taxCode;

            public ShippingCost build() {
                return new ShippingCost(this.amount, this.extraParams, this.shippingRate, this.taxBehavior, this.taxCode);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setShippingRate(String shippingRate) {
                this.shippingRate = shippingRate;
                return this;
            }

            public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                this.taxBehavior = taxBehavior;
                return this;
            }

            public Builder setTaxCode(String taxCode) {
                this.taxCode = taxCode;
                return this;
            }
        }
    }

    public static class Builder {
        private String currency;
        private String customer;
        private CustomerDetails customerDetails;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private List<LineItem> lineItems;
        private ShipFromDetails shipFromDetails;
        private ShippingCost shippingCost;
        private Long taxDate;

        public CalculationCreateParams build() {
            return new CalculationCreateParams(this.currency, this.customer, this.customerDetails, this.expand, this.extraParams, this.lineItems, this.shipFromDetails, this.shippingCost, this.taxDate);
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerDetails(CustomerDetails customerDetails) {
            this.customerDetails = customerDetails;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder setShipFromDetails(ShipFromDetails shipFromDetails) {
            this.shipFromDetails = shipFromDetails;
            return this;
        }

        public Builder setShippingCost(ShippingCost shippingCost) {
            this.shippingCost = shippingCost;
            return this;
        }

        public Builder setTaxDate(Long taxDate) {
            this.taxDate = taxDate;
            return this;
        }
    }

    public static class LineItem {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="product")
        String product;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="reference")
        String reference;
        @SerializedName(value="tax_behavior")
        TaxBehavior taxBehavior;
        @SerializedName(value="tax_code")
        String taxCode;

        private LineItem(Long amount, Map<String, Object> extraParams, String product, Long quantity, String reference, TaxBehavior taxBehavior, String taxCode) {
            this.amount = amount;
            this.extraParams = extraParams;
            this.product = product;
            this.quantity = quantity;
            this.reference = reference;
            this.taxBehavior = taxBehavior;
            this.taxCode = taxCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getProduct() {
            return this.product;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public TaxBehavior getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public String getTaxCode() {
            return this.taxCode;
        }

        public static enum TaxBehavior implements ApiRequestParams.EnumParam
        {
            EXCLUSIVE("exclusive"),
            INCLUSIVE("inclusive");

            private final String value;

            private TaxBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;
            private String product;
            private Long quantity;
            private String reference;
            private TaxBehavior taxBehavior;
            private String taxCode;

            public LineItem build() {
                return new LineItem(this.amount, this.extraParams, this.product, this.quantity, this.reference, this.taxBehavior, this.taxCode);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setProduct(String product) {
                this.product = product;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder setReference(String reference) {
                this.reference = reference;
                return this;
            }

            public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                this.taxBehavior = taxBehavior;
                return this;
            }

            public Builder setTaxCode(String taxCode) {
                this.taxCode = taxCode;
                return this;
            }
        }
    }
}

