/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.radar.ValueListCollection;
import com.stripe.model.radar.ValueListItemCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.radar.ValueListCreateParams;
import com.stripe.param.radar.ValueListListParams;
import com.stripe.param.radar.ValueListRetrieveParams;
import com.stripe.param.radar.ValueListUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class ValueList
extends ApiResource
implements HasId,
MetadataStore<ValueList> {
    @SerializedName(value="alias")
    String alias;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="created_by")
    String createdBy;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="item_type")
    String itemType;
    @SerializedName(value="list_items")
    ValueListItemCollection listItems;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;

    public static ValueList create(Map<String, Object> params) throws StripeException {
        return ValueList.create(params, (RequestOptions)null);
    }

    public static ValueList create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (ValueList)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public static ValueList create(ValueListCreateParams params) throws StripeException {
        return ValueList.create(params, (RequestOptions)null);
    }

    public static ValueList create(ValueListCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ValueList)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public ValueList delete() throws StripeException {
        return this.delete(null, null);
    }

    public ValueList delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public ValueList delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public ValueList delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options, ApiMode.V1);
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public static ValueListCollection list(Map<String, Object> params) throws StripeException {
        return ValueList.list(params, (RequestOptions)null);
    }

    public static ValueListCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ValueListCollection)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueListCollection.class));
    }

    public static ValueListCollection list(ValueListListParams params) throws StripeException {
        return ValueList.list(params, (RequestOptions)null);
    }

    public static ValueListCollection list(ValueListListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ValueListCollection)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueListCollection.class));
    }

    public static ValueList retrieve(String valueList) throws StripeException {
        return ValueList.retrieve(valueList, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ValueList retrieve(String valueList, RequestOptions options) throws StripeException {
        return ValueList.retrieve(valueList, (Map<String, Object>)null, options);
    }

    public static ValueList retrieve(String valueList, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(valueList));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ValueList)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public static ValueList retrieve(String valueList, ValueListRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(valueList));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ValueList)ValueList.getGlobalResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public ValueList update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public ValueList update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public ValueList update(ValueListUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public ValueList update(ValueListUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.listItems, responseGetter);
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getItemType() {
        return this.itemType;
    }

    @Generated
    public ValueListItemCollection getListItems() {
        return this.listItems;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    @Generated
    public void setListItems(ValueListItemCollection listItems) {
        this.listItems = listItems;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueList)) {
            return false;
        }
        ValueList other = (ValueList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$itemType = this.getItemType();
        String other$itemType = other.getItemType();
        if (this$itemType == null ? other$itemType != null : !this$itemType.equals(other$itemType)) {
            return false;
        }
        ValueListItemCollection this$listItems = this.getListItems();
        ValueListItemCollection other$listItems = other.getListItems();
        if (this$listItems == null ? other$listItems != null : !((Object)this$listItems).equals(other$listItems)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValueList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $itemType = this.getItemType();
        result = result * 59 + ($itemType == null ? 43 : $itemType.hashCode());
        ValueListItemCollection $listItems = this.getListItems();
        result = result * 59 + ($listItems == null ? 43 : ((Object)$listItems).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

