/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.climate;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.climate.ProductCollection;
import com.stripe.model.climate.Supplier;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.climate.ProductListParams;
import com.stripe.param.climate.ProductRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Product
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="current_prices_per_metric_ton")
    Map<String, CurrentPricesPerMetricTon> currentPricesPerMetricTon;
    @SerializedName(value="delivery_year")
    Long deliveryYear;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metric_tons_available")
    BigDecimal metricTonsAvailable;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="suppliers")
    List<Supplier> suppliers;

    public static ProductCollection list(Map<String, Object> params) throws StripeException {
        return Product.list(params, (RequestOptions)null);
    }

    public static ProductCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/products";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ProductCollection)Product.getGlobalResponseGetter().request(request, (Type)((Object)ProductCollection.class));
    }

    public static ProductCollection list(ProductListParams params) throws StripeException {
        return Product.list(params, (RequestOptions)null);
    }

    public static ProductCollection list(ProductListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/products";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ProductCollection)Product.getGlobalResponseGetter().request(request, (Type)((Object)ProductCollection.class));
    }

    public static Product retrieve(String product) throws StripeException {
        return Product.retrieve(product, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Product retrieve(String product, RequestOptions options) throws StripeException {
        return Product.retrieve(product, (Map<String, Object>)null, options);
    }

    public static Product retrieve(String product, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/products/%s", ApiResource.urlEncodeId(product));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Product)Product.getGlobalResponseGetter().request(request, (Type)((Object)Product.class));
    }

    public static Product retrieve(String product, ProductRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/products/%s", ApiResource.urlEncodeId(product));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Product)Product.getGlobalResponseGetter().request(request, (Type)((Object)Product.class));
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Map<String, CurrentPricesPerMetricTon> getCurrentPricesPerMetricTon() {
        return this.currentPricesPerMetricTon;
    }

    @Generated
    public Long getDeliveryYear() {
        return this.deliveryYear;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public BigDecimal getMetricTonsAvailable() {
        return this.metricTonsAvailable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Supplier> getSuppliers() {
        return this.suppliers;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPricesPerMetricTon(Map<String, CurrentPricesPerMetricTon> currentPricesPerMetricTon) {
        this.currentPricesPerMetricTon = currentPricesPerMetricTon;
    }

    @Generated
    public void setDeliveryYear(Long deliveryYear) {
        this.deliveryYear = deliveryYear;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetricTonsAvailable(BigDecimal metricTonsAvailable) {
        this.metricTonsAvailable = metricTonsAvailable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSuppliers(List<Supplier> suppliers) {
        this.suppliers = suppliers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$deliveryYear = this.getDeliveryYear();
        Long other$deliveryYear = other.getDeliveryYear();
        if (this$deliveryYear == null ? other$deliveryYear != null : !((Object)this$deliveryYear).equals(other$deliveryYear)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, CurrentPricesPerMetricTon> this$currentPricesPerMetricTon = this.getCurrentPricesPerMetricTon();
        Map<String, CurrentPricesPerMetricTon> other$currentPricesPerMetricTon = other.getCurrentPricesPerMetricTon();
        if (this$currentPricesPerMetricTon == null ? other$currentPricesPerMetricTon != null : !((Object)this$currentPricesPerMetricTon).equals(other$currentPricesPerMetricTon)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        BigDecimal this$metricTonsAvailable = this.getMetricTonsAvailable();
        BigDecimal other$metricTonsAvailable = other.getMetricTonsAvailable();
        if (this$metricTonsAvailable == null ? other$metricTonsAvailable != null : !((Object)this$metricTonsAvailable).equals(other$metricTonsAvailable)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Supplier> this$suppliers = this.getSuppliers();
        List<Supplier> other$suppliers = other.getSuppliers();
        return !(this$suppliers == null ? other$suppliers != null : !((Object)this$suppliers).equals(other$suppliers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $deliveryYear = this.getDeliveryYear();
        result = result * 59 + ($deliveryYear == null ? 43 : ((Object)$deliveryYear).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, CurrentPricesPerMetricTon> $currentPricesPerMetricTon = this.getCurrentPricesPerMetricTon();
        result = result * 59 + ($currentPricesPerMetricTon == null ? 43 : ((Object)$currentPricesPerMetricTon).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        BigDecimal $metricTonsAvailable = this.getMetricTonsAvailable();
        result = result * 59 + ($metricTonsAvailable == null ? 43 : ((Object)$metricTonsAvailable).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Supplier> $suppliers = this.getSuppliers();
        result = result * 59 + ($suppliers == null ? 43 : ((Object)$suppliers).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CurrentPricesPerMetricTon
    extends StripeObject {
        @SerializedName(value="amount_fees")
        Long amountFees;
        @SerializedName(value="amount_subtotal")
        Long amountSubtotal;
        @SerializedName(value="amount_total")
        Long amountTotal;

        @Generated
        public Long getAmountFees() {
            return this.amountFees;
        }

        @Generated
        public Long getAmountSubtotal() {
            return this.amountSubtotal;
        }

        @Generated
        public Long getAmountTotal() {
            return this.amountTotal;
        }

        @Generated
        public void setAmountFees(Long amountFees) {
            this.amountFees = amountFees;
        }

        @Generated
        public void setAmountSubtotal(Long amountSubtotal) {
            this.amountSubtotal = amountSubtotal;
        }

        @Generated
        public void setAmountTotal(Long amountTotal) {
            this.amountTotal = amountTotal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentPricesPerMetricTon)) {
                return false;
            }
            CurrentPricesPerMetricTon other = (CurrentPricesPerMetricTon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountFees = this.getAmountFees();
            Long other$amountFees = other.getAmountFees();
            if (this$amountFees == null ? other$amountFees != null : !((Object)this$amountFees).equals(other$amountFees)) {
                return false;
            }
            Long this$amountSubtotal = this.getAmountSubtotal();
            Long other$amountSubtotal = other.getAmountSubtotal();
            if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
                return false;
            }
            Long this$amountTotal = this.getAmountTotal();
            Long other$amountTotal = other.getAmountTotal();
            return !(this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrentPricesPerMetricTon;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountFees = this.getAmountFees();
            result = result * 59 + ($amountFees == null ? 43 : ((Object)$amountFees).hashCode());
            Long $amountSubtotal = this.getAmountSubtotal();
            result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
            Long $amountTotal = this.getAmountTotal();
            result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
            return result;
        }
    }
}

