/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Payout;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PayoutCancelParams;
import com.stripe.param.PayoutCreateParams;
import com.stripe.param.PayoutListParams;
import com.stripe.param.PayoutRetrieveParams;
import com.stripe.param.PayoutReverseParams;
import com.stripe.param.PayoutUpdateParams;
import java.lang.reflect.Type;

public final class PayoutService
extends ApiService {
    public PayoutService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Payout> list(PayoutListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Payout> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Payout> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Payout> list(PayoutListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Payout>>(){}.getType());
    }

    public Payout create(PayoutCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Payout create(PayoutCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payouts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.request(request, (Type)((Object)Payout.class));
    }

    public Payout retrieve(String payout, PayoutRetrieveParams params) throws StripeException {
        return this.retrieve(payout, params, null);
    }

    public Payout retrieve(String payout, RequestOptions options) throws StripeException {
        return this.retrieve(payout, null, options);
    }

    public Payout retrieve(String payout) throws StripeException {
        return this.retrieve(payout, null, null);
    }

    public Payout retrieve(String payout, PayoutRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(payout));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.request(request, (Type)((Object)Payout.class));
    }

    public Payout update(String payout, PayoutUpdateParams params) throws StripeException {
        return this.update(payout, params, null);
    }

    public Payout update(String payout, RequestOptions options) throws StripeException {
        return this.update(payout, null, options);
    }

    public Payout update(String payout) throws StripeException {
        return this.update(payout, null, null);
    }

    public Payout update(String payout, PayoutUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s", ApiResource.urlEncodeId(payout));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.request(request, (Type)((Object)Payout.class));
    }

    public Payout cancel(String payout, PayoutCancelParams params) throws StripeException {
        return this.cancel(payout, params, null);
    }

    public Payout cancel(String payout, RequestOptions options) throws StripeException {
        return this.cancel(payout, null, options);
    }

    public Payout cancel(String payout) throws StripeException {
        return this.cancel(payout, null, null);
    }

    public Payout cancel(String payout, PayoutCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/cancel", ApiResource.urlEncodeId(payout));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.request(request, (Type)((Object)Payout.class));
    }

    public Payout reverse(String payout, PayoutReverseParams params) throws StripeException {
        return this.reverse(payout, params, null);
    }

    public Payout reverse(String payout, RequestOptions options) throws StripeException {
        return this.reverse(payout, null, options);
    }

    public Payout reverse(String payout) throws StripeException {
        return this.reverse(payout, null, null);
    }

    public Payout reverse(String payout, PayoutReverseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payouts/%s/reverse", ApiResource.urlEncodeId(payout));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Payout)this.request(request, (Type)((Object)Payout.class));
    }
}

