/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.stripe.exception.StripeException;
import com.stripe.model.CashBalance;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerCashBalanceRetrieveParams;
import com.stripe.param.CustomerCashBalanceUpdateParams;
import java.lang.reflect.Type;

public final class CustomerCashBalanceService
extends ApiService {
    public CustomerCashBalanceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public CashBalance retrieve(String customer, CustomerCashBalanceRetrieveParams params) throws StripeException {
        return this.retrieve(customer, params, null);
    }

    public CashBalance retrieve(String customer, RequestOptions options) throws StripeException {
        return this.retrieve(customer, null, options);
    }

    public CashBalance retrieve(String customer) throws StripeException {
        return this.retrieve(customer, null, null);
    }

    public CashBalance retrieve(String customer, CustomerCashBalanceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CashBalance)this.request(request, (Type)((Object)CashBalance.class));
    }

    public CashBalance update(String customer, CustomerCashBalanceUpdateParams params) throws StripeException {
        return this.update(customer, params, null);
    }

    public CashBalance update(String customer, RequestOptions options) throws StripeException {
        return this.update(customer, null, options);
    }

    public CashBalance update(String customer) throws StripeException {
        return this.update(customer, null, null);
    }

    public CashBalance update(String customer, CustomerCashBalanceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/cash_balance", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CashBalance)this.request(request, (Type)((Object)CashBalance.class));
    }
}

