/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.stripe.exception.StripeException;
import com.stripe.model.treasury.FinancialAccountFeatures;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.FinancialAccountFeaturesCreateParams;
import com.stripe.param.treasury.FinancialAccountFeaturesListParams;
import java.lang.reflect.Type;

public final class FinancialAccountFeaturesService
extends ApiService {
    public FinancialAccountFeaturesService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public FinancialAccountFeatures create(String financialAccount, FinancialAccountFeaturesCreateParams params) throws StripeException {
        return this.create(financialAccount, params, null);
    }

    public FinancialAccountFeatures create(String financialAccount, RequestOptions options) throws StripeException {
        return this.create(financialAccount, null, options);
    }

    public FinancialAccountFeatures create(String financialAccount) throws StripeException {
        return this.create(financialAccount, null, null);
    }

    public FinancialAccountFeatures create(String financialAccount, FinancialAccountFeaturesCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(financialAccount));
        return (FinancialAccountFeatures)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)FinancialAccountFeatures.class), options, ApiMode.V1);
    }

    public FinancialAccountFeatures list(String financialAccount, FinancialAccountFeaturesListParams params) throws StripeException {
        return this.list(financialAccount, params, null);
    }

    public FinancialAccountFeatures list(String financialAccount, RequestOptions options) throws StripeException {
        return this.list(financialAccount, null, options);
    }

    public FinancialAccountFeatures list(String financialAccount) throws StripeException {
        return this.list(financialAccount, null, null);
    }

    public FinancialAccountFeatures list(String financialAccount, FinancialAccountFeaturesListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s/features", ApiResource.urlEncodeId(financialAccount));
        return (FinancialAccountFeatures)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)FinancialAccountFeatures.class), options, ApiMode.V1);
    }
}

