/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.financialconnections;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.financialconnections.Account;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.financialconnections.AccountDisconnectParams;
import com.stripe.param.financialconnections.AccountListParams;
import com.stripe.param.financialconnections.AccountRefreshParams;
import com.stripe.param.financialconnections.AccountRetrieveParams;
import com.stripe.param.financialconnections.AccountSubscribeParams;
import com.stripe.param.financialconnections.AccountUnsubscribeParams;
import com.stripe.service.financialconnections.AccountOwnerService;
import java.lang.reflect.Type;

public final class AccountService
extends ApiService {
    public AccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Account> list(AccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Account> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Account> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Account> list(AccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/accounts";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Account>>(){}.getType(), options, ApiMode.V1);
    }

    public Account retrieve(String account, AccountRetrieveParams params) throws StripeException {
        return this.retrieve(account, params, null);
    }

    public Account retrieve(String account, RequestOptions options) throws StripeException {
        return this.retrieve(account, null, options);
    }

    public Account retrieve(String account) throws StripeException {
        return this.retrieve(account, null, null);
    }

    public Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/accounts/%s", ApiResource.urlEncodeId(account));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account refresh(String account, AccountRefreshParams params) throws StripeException {
        return this.refresh(account, params, null);
    }

    public Account refresh(String account, AccountRefreshParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/accounts/%s/refresh", ApiResource.urlEncodeId(account));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account disconnect(String account, AccountDisconnectParams params) throws StripeException {
        return this.disconnect(account, params, null);
    }

    public Account disconnect(String account, RequestOptions options) throws StripeException {
        return this.disconnect(account, null, options);
    }

    public Account disconnect(String account) throws StripeException {
        return this.disconnect(account, null, null);
    }

    public Account disconnect(String account, AccountDisconnectParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/accounts/%s/disconnect", ApiResource.urlEncodeId(account));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account subscribe(String account, AccountSubscribeParams params) throws StripeException {
        return this.subscribe(account, params, null);
    }

    public Account subscribe(String account, AccountSubscribeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/accounts/%s/subscribe", ApiResource.urlEncodeId(account));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public Account unsubscribe(String account, AccountUnsubscribeParams params) throws StripeException {
        return this.unsubscribe(account, params, null);
    }

    public Account unsubscribe(String account, AccountUnsubscribeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/accounts/%s/unsubscribe", ApiResource.urlEncodeId(account));
        return (Account)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Account.class), options, ApiMode.V1);
    }

    public AccountOwnerService owners() {
        return new AccountOwnerService(this.getResponseGetter());
    }
}

