/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.terminal.LocationCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.LocationCreateParams;
import com.stripe.param.terminal.LocationListParams;
import com.stripe.param.terminal.LocationRetrieveParams;
import com.stripe.param.terminal.LocationUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Location
extends ApiResource
implements HasId,
MetadataStore<Location> {
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="configuration_overrides")
    String configurationOverrides;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="display_name")
    String displayName;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;

    public static Location create(Map<String, Object> params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        return (Location)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public static Location create(LocationCreateParams params) throws StripeException {
        return Location.create(params, (RequestOptions)null);
    }

    public static Location create(LocationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiResource.checkNullTypedParams(path, params);
        return (Location)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public Location delete() throws StripeException {
        return this.delete(null, null);
    }

    public Location delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Location delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Location delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        return (Location)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public static LocationCollection list(Map<String, Object> params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        return (LocationCollection)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)LocationCollection.class), options, ApiMode.V1);
    }

    public static LocationCollection list(LocationListParams params) throws StripeException {
        return Location.list(params, (RequestOptions)null);
    }

    public static LocationCollection list(LocationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/locations";
        ApiResource.checkNullTypedParams(path, params);
        return (LocationCollection)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)LocationCollection.class), options, ApiMode.V1);
    }

    public static Location retrieve(String location) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Location retrieve(String location, RequestOptions options) throws StripeException {
        return Location.retrieve(location, (Map<String, Object>)null, options);
    }

    public static Location retrieve(String location, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        return (Location)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public static Location retrieve(String location, LocationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(location));
        ApiResource.checkNullTypedParams(path, params);
        return (Location)Location.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public Location update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Location update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        return (Location)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Location.class), options, ApiMode.V1);
    }

    public Location update(LocationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Location update(LocationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/locations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Location)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Location.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.address, responseGetter);
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public String getConfigurationOverrides() {
        return this.configurationOverrides;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setConfigurationOverrides(String configurationOverrides) {
        this.configurationOverrides = configurationOverrides;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$configurationOverrides = this.getConfigurationOverrides();
        String other$configurationOverrides = other.getConfigurationOverrides();
        if (this$configurationOverrides == null ? other$configurationOverrides != null : !this$configurationOverrides.equals(other$configurationOverrides)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $configurationOverrides = this.getConfigurationOverrides();
        result = result * 59 + ($configurationOverrides == null ? 43 : $configurationOverrides.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

