/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.climate;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.climate.SupplierCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.climate.SupplierListParams;
import com.stripe.param.climate.SupplierRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Supplier
extends ApiResource
implements HasId {
    @SerializedName(value="id")
    String id;
    @SerializedName(value="info_url")
    String infoUrl;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="locations")
    List<Location> locations;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="removal_pathway")
    String removalPathway;

    public static SupplierCollection list(Map<String, Object> params) throws StripeException {
        return Supplier.list(params, (RequestOptions)null);
    }

    public static SupplierCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/suppliers";
        return (SupplierCollection)Supplier.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)SupplierCollection.class), options, ApiMode.V1);
    }

    public static SupplierCollection list(SupplierListParams params) throws StripeException {
        return Supplier.list(params, (RequestOptions)null);
    }

    public static SupplierCollection list(SupplierListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/suppliers";
        ApiResource.checkNullTypedParams(path, params);
        return (SupplierCollection)Supplier.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)SupplierCollection.class), options, ApiMode.V1);
    }

    public static Supplier retrieve(String supplier) throws StripeException {
        return Supplier.retrieve(supplier, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Supplier retrieve(String supplier, RequestOptions options) throws StripeException {
        return Supplier.retrieve(supplier, (Map<String, Object>)null, options);
    }

    public static Supplier retrieve(String supplier, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/suppliers/%s", ApiResource.urlEncodeId(supplier));
        return (Supplier)Supplier.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Supplier.class), options, ApiMode.V1);
    }

    public static Supplier retrieve(String supplier, SupplierRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/suppliers/%s", ApiResource.urlEncodeId(supplier));
        ApiResource.checkNullTypedParams(path, params);
        return (Supplier)Supplier.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Supplier.class), options, ApiMode.V1);
    }

    @Generated
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public List<Location> getLocations() {
        return this.locations;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getRemovalPathway() {
        return this.removalPathway;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRemovalPathway(String removalPathway) {
        this.removalPathway = removalPathway;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Supplier)) {
            return false;
        }
        Supplier other = (Supplier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$infoUrl = this.getInfoUrl();
        String other$infoUrl = other.getInfoUrl();
        if (this$infoUrl == null ? other$infoUrl != null : !this$infoUrl.equals(other$infoUrl)) {
            return false;
        }
        List<Location> this$locations = this.getLocations();
        List<Location> other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$removalPathway = this.getRemovalPathway();
        String other$removalPathway = other.getRemovalPathway();
        return !(this$removalPathway == null ? other$removalPathway != null : !this$removalPathway.equals(other$removalPathway));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Supplier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $infoUrl = this.getInfoUrl();
        result = result * 59 + ($infoUrl == null ? 43 : $infoUrl.hashCode());
        List<Location> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $removalPathway = this.getRemovalPathway();
        result = result * 59 + ($removalPathway == null ? 43 : $removalPathway.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Location
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="latitude")
        BigDecimal latitude;
        @SerializedName(value="longitude")
        BigDecimal longitude;
        @SerializedName(value="region")
        String region;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public BigDecimal getLatitude() {
            return this.latitude;
        }

        @Generated
        public BigDecimal getLongitude() {
            return this.longitude;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        @Generated
        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }

        @Generated
        public void setRegion(String region) {
            this.region = region;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            BigDecimal this$latitude = this.getLatitude();
            BigDecimal other$latitude = other.getLatitude();
            if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                return false;
            }
            BigDecimal this$longitude = this.getLongitude();
            BigDecimal other$longitude = other.getLongitude();
            if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Location;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            BigDecimal $latitude = this.getLatitude();
            result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
            BigDecimal $longitude = this.getLongitude();
            result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }
    }
}

