/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.strings;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import com.stripe.android.core.strings.ConcatenatedResolvableString;
import com.stripe.android.core.strings.IdentifierResolvableString;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.StaticResolvableString;
import com.stripe.android.core.strings.transformations.TransformOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u001a-\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001aI\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2 \u0010\f\u001a\u0011\u0012\r\b\u0001\u0012\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\r0\u0001\"\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0007\u00a2\u0006\u0002\u0010\u0010\u001a7\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122 \u0010\f\u001a\u0011\u0012\r\b\u0001\u0012\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\r0\u0001\"\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0017\u001a\u00020\t*\u0004\u0018\u00010\tH\u0007\u001a\u0015\u0010\u0018\u001a\u00020\t*\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0087\u0002\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\b\u001a\u00020\t*\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001a"}, d2={"resolveArgs", "", "", "context", "Landroid/content/Context;", "args", "", "(Landroid/content/Context;Ljava/util/List;)[Ljava/lang/Object;", "resolvableString", "Lcom/stripe/android/core/strings/ResolvableString;", "id", "", "formatArgs", "Lkotlinx/parcelize/RawValue;", "transformations", "Lcom/stripe/android/core/strings/transformations/TransformOperation;", "(I[Ljava/lang/Object;Ljava/util/List;)Lcom/stripe/android/core/strings/ResolvableString;", "value", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/stripe/android/core/strings/ResolvableString;", "getResolvableString", "(Ljava/lang/String;)Lcom/stripe/android/core/strings/ResolvableString;", "(I)Lcom/stripe/android/core/strings/ResolvableString;", "orEmpty", "plus", "other", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nResolvableStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolvableStringUtils.kt\ncom/stripe/android/core/strings/ResolvableStringUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n1557#2:74\n1628#2,3:75\n37#3:78\n36#3,3:79\n*S KotlinDebug\n*F\n+ 1 ResolvableStringUtils.kt\ncom/stripe/android/core/strings/ResolvableStringUtilsKt\n*L\n12#1:74\n12#1:75,3\n17#1:78\n17#1:79,3\n*E\n"})
public final class ResolvableStringUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object[] resolveArgs(@NotNull Context context, @NotNull List<? extends Object> args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void arg;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(arg instanceof ResolvableString ? ((ResolvableString)arg).resolve(context) : arg);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString resolvableString(@StringRes int id, @NotNull Object[] formatArgs, @NotNull List<? extends TransformOperation> transformations) {
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        Intrinsics.checkNotNullParameter(transformations, (String)"transformations");
        return new IdentifierResolvableString(id, transformations, ArraysKt.toList((Object[])formatArgs));
    }

    public static /* synthetic */ ResolvableString resolvableString$default(int n, Object[] objectArray, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return ResolvableStringUtilsKt.resolvableString(n, objectArray, list);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString resolvableString(@NotNull String value, Object ... formatArgs) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        return new StaticResolvableString(value, ArraysKt.toList((Object[])formatArgs));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString getResolvableString(@NotNull String $this$resolvableString) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvableString, (String)"<this>");
        return new StaticResolvableString($this$resolvableString, CollectionsKt.emptyList());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString getResolvableString(@StringRes int $this$resolvableString) {
        return new IdentifierResolvableString($this$resolvableString, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString orEmpty(@Nullable ResolvableString $this$orEmpty) {
        ResolvableString resolvableString = $this$orEmpty;
        if (resolvableString == null) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString("");
        }
        return resolvableString;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ResolvableString plus(@NotNull ResolvableString $this$plus, @NotNull ResolvableString other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new ConcatenatedResolvableString($this$plus, other);
    }
}

