/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.StripeResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u000f\u0010\u0011J\u0019\u0010\u000b\u001a\u0004\u0018\u00018\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH&\u00a2\u0006\u0002\u0010\u000eR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/core/networking/StripeConnection;", "ResponseBodyType", "Ljava/io/Closeable;", "responseCode", "", "getResponseCode", "()I", "response", "Lcom/stripe/android/core/networking/StripeResponse;", "getResponse", "()Lcom/stripe/android/core/networking/StripeResponse;", "createBodyFromResponseStream", "responseStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Ljava/lang/Object;", "AbstractConnection", "Default", "FileConnection", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface StripeConnection<ResponseBodyType>
extends Closeable {
    public int getResponseCode();

    @NotNull
    public StripeResponse<ResponseBodyType> getResponse();

    @Nullable
    public ResponseBodyType createBodyFromResponseStream(@Nullable InputStream var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u0015*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/core/networking/StripeConnection$AbstractConnection;", "ResponseBodyType", "Lcom/stripe/android/core/networking/StripeConnection;", "conn", "Ljavax/net/ssl/HttpsURLConnection;", "<init>", "(Ljavax/net/ssl/HttpsURLConnection;)V", "responseCode", "", "getResponseCode", "()I", "response", "Lcom/stripe/android/core/networking/StripeResponse;", "getResponse", "()Lcom/stripe/android/core/networking/StripeResponse;", "responseStream", "Ljava/io/InputStream;", "getResponseStream", "()Ljava/io/InputStream;", "close", "", "Companion", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class AbstractConnection<ResponseBodyType>
    implements StripeConnection<ResponseBodyType> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HttpsURLConnection conn;
        private static final String CHARSET = StandardCharsets.UTF_8.name();

        public AbstractConnection(@NotNull HttpsURLConnection conn) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            this.conn = conn;
        }

        @Override
        public /* synthetic */ int getResponseCode() {
            return this.conn.getResponseCode();
        }

        @Override
        public /* synthetic */ StripeResponse getResponse() throws IOException {
            int responseCode = this.getResponseCode();
            Object ResponseBodyType = this.createBodyFromResponseStream(this.getResponseStream());
            Map<String, List<String>> map = this.conn.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getHeaderFields(...)");
            return new StripeResponse(responseCode, ResponseBodyType, map);
        }

        private final InputStream getResponseStream() throws IOException {
            int n = this.getResponseCode();
            return (200 <= n ? n < 300 : false) ? this.conn.getInputStream() : this.conn.getErrorStream();
        }

        @Override
        public void close() {
            InputStream inputStream = this.getResponseStream();
            if (inputStream != null) {
                inputStream.close();
            }
            this.conn.disconnect();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/stripe/android/core/networking/StripeConnection$AbstractConnection$Companion;", "", "<init>", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "getCHARSET$stripe_core_release", "()Ljava/lang/String;", "Ljava/lang/String;", "stripe-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public final String getCHARSET$stripe_core_release() {
                return CHARSET;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/stripe/android/core/networking/StripeConnection$Default;", "Lcom/stripe/android/core/networking/StripeConnection$AbstractConnection;", "", "conn", "Ljavax/net/ssl/HttpsURLConnection;", "<init>", "(Ljavax/net/ssl/HttpsURLConnection;)V", "createBodyFromResponseStream", "responseStream", "Ljava/io/InputStream;", "stripe-core_release"})
    public static final class Default
    extends AbstractConnection<String> {
        public Default(@NotNull HttpsURLConnection conn) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            super(conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String createBodyFromResponseStream(@Nullable InputStream responseStream) throws IOException {
            if (responseStream == null) {
                return null;
            }
            Closeable closeable = responseStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Scanner scanner = new Scanner(responseStream, AbstractConnection.Companion.getCHARSET$stripe_core_release()).useDelimiter("\\A");
                String string = scanner.hasNext() ? scanner.next() : null;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/core/networking/StripeConnection$FileConnection;", "Lcom/stripe/android/core/networking/StripeConnection$AbstractConnection;", "Ljava/io/File;", "conn", "Ljavax/net/ssl/HttpsURLConnection;", "outputFile", "<init>", "(Ljavax/net/ssl/HttpsURLConnection;Ljava/io/File;)V", "createBodyFromResponseStream", "responseStream", "Ljava/io/InputStream;", "stripe-core_release"})
    @SourceDebugExtension(value={"SMAP\nStripeConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeConnection.kt\ncom/stripe/android/core/networking/StripeConnection$FileConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
    public static final class FileConnection
    extends AbstractConnection<File> {
        @NotNull
        private final File outputFile;

        public FileConnection(@NotNull HttpsURLConnection conn, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            super(conn);
            this.outputFile = outputFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public File createBodyFromResponseStream(@Nullable InputStream responseStream) throws IOException {
            if (responseStream == null) {
                return null;
            }
            Closeable closeable = responseStream;
            Throwable throwable = null;
            try {
                long l;
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(this.outputFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)stream, (OutputStream)it, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return this.outputFile;
        }
    }
}

