/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.AppInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u0014\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/core/networking/StripeClientUserAgentHeaderFactory;", "", "systemPropertySupplier", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "create", "", "appInfo", "Lcom/stripe/android/core/AppInfo;", "createHeaderValue", "Lorg/json/JSONObject;", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class StripeClientUserAgentHeaderFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, String> systemPropertySupplier;
    @NotNull
    private static final String PROP_USER_AGENT = "http.agent";
    @NotNull
    private static final Function1<String, String> DEFAULT_SYSTEM_PROPERTY_SUPPLIER = StripeClientUserAgentHeaderFactory::DEFAULT_SYSTEM_PROPERTY_SUPPLIER$lambda$0;
    @NotNull
    public static final String HEADER_STRIPE_CLIENT_USER_AGENT = "X-Stripe-Client-User-Agent";

    public StripeClientUserAgentHeaderFactory(@NotNull Function1<? super String, String> systemPropertySupplier) {
        Intrinsics.checkNotNullParameter(systemPropertySupplier, (String)"systemPropertySupplier");
        this.systemPropertySupplier = systemPropertySupplier;
    }

    public /* synthetic */ StripeClientUserAgentHeaderFactory(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
        }
        this(function1);
    }

    @NotNull
    public final Map<String, String> create(@Nullable AppInfo appInfo) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)HEADER_STRIPE_CLIENT_USER_AGENT, (Object)this.createHeaderValue(appInfo).toString()));
    }

    public static /* synthetic */ Map create$default(StripeClientUserAgentHeaderFactory stripeClientUserAgentHeaderFactory, AppInfo appInfo, int n, Object object) {
        if ((n & 1) != 0) {
            appInfo = null;
        }
        return stripeClientUserAgentHeaderFactory.create(appInfo);
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject createHeaderValue(@Nullable AppInfo appInfo) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"os.name", (Object)"android"), TuplesKt.to((Object)"os.version", (Object)String.valueOf(Build.VERSION.SDK_INT)), TuplesKt.to((Object)"bindings.version", (Object)"21.10.0"), TuplesKt.to((Object)"lang", (Object)"Java"), TuplesKt.to((Object)"publisher", (Object)"Stripe"), TuplesKt.to((Object)PROP_USER_AGENT, (Object)this.systemPropertySupplier.invoke((Object)PROP_USER_AGENT))};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        AppInfo appInfo2 = appInfo;
        Map map2 = appInfo2 != null ? appInfo2.createClientHeaders$stripe_core_release() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return new JSONObject(MapsKt.plus((Map)map, map2));
    }

    public static /* synthetic */ JSONObject createHeaderValue$default(StripeClientUserAgentHeaderFactory stripeClientUserAgentHeaderFactory, AppInfo appInfo, int n, Object object) {
        if ((n & 1) != 0) {
            appInfo = null;
        }
        return stripeClientUserAgentHeaderFactory.createHeaderValue(appInfo);
    }

    private static final String DEFAULT_SYSTEM_PROPERTY_SUPPLIER$lambda$0(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = System.getProperty(name);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public StripeClientUserAgentHeaderFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/core/networking/StripeClientUserAgentHeaderFactory$Companion;", "", "<init>", "()V", "PROP_USER_AGENT", "", "DEFAULT_SYSTEM_PROPERTY_SUPPLIER", "Lkotlin/Function1;", "HEADER_STRIPE_CLIENT_USER_AGENT", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

