/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.AppInfo;
import com.stripe.android.core.model.StripeFileParams;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.NetworkConstantsKt;
import com.stripe.android.core.networking.RequestHeadersFactory;
import com.stripe.android.core.networking.StripeRequest;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 42\u00020\u0001:\u00014B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tH\u0004J\u0010\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R(\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u0011\u00100\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR\u0011\u00102\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\r\u00a8\u00065"}, d2={"Lcom/stripe/android/core/networking/FileUploadRequest;", "Lcom/stripe/android/core/networking/StripeRequest;", "fileParams", "Lcom/stripe/android/core/model/StripeFileParams;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/core/AppInfo;", "boundary", "", "<init>", "(Lcom/stripe/android/core/model/StripeFileParams;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/core/AppInfo;Ljava/lang/String;)V", "getBoundary", "()Ljava/lang/String;", "headersFactory", "Lcom/stripe/android/core/networking/RequestHeadersFactory;", "method", "Lcom/stripe/android/core/networking/StripeRequest$Method;", "getMethod", "()Lcom/stripe/android/core/networking/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "getMimeType", "()Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "url", "getUrl", "retryResponseCodes", "", "", "getRetryResponseCodes", "()Ljava/lang/Iterable;", "headers", "", "getHeaders", "()Ljava/util/Map;", "postHeaders", "getPostHeaders", "setPostHeaders", "(Ljava/util/Map;)V", "writePostBody", "", "outputStream", "Ljava/io/OutputStream;", "writeString", "writer", "Ljava/io/PrintWriter;", "contents", "writeFile", "fileMetadata", "getFileMetadata", "purposeContents", "getPurposeContents", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FileUploadRequest
extends StripeRequest {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeFileParams fileParams;
    @NotNull
    private final String boundary;
    @NotNull
    private final RequestHeadersFactory headersFactory;
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final String url;
    @NotNull
    private final Iterable<Integer> retryResponseCodes;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private Map<String, String> postHeaders;
    @NotNull
    public static final String LINE_BREAK = "\r\n";
    @NotNull
    private static final String HOST = "https://files.stripe.com/v1/files";

    public FileUploadRequest(@NotNull StripeFileParams fileParams, @NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)fileParams, (String)"fileParams");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        this.fileParams = fileParams;
        this.boundary = boundary;
        this.headersFactory = new RequestHeadersFactory.FileUpload(options, appInfo, null, null, null, this.boundary, 28, null);
        this.method = StripeRequest.Method.POST;
        this.mimeType = StripeRequest.MimeType.MultipartForm;
        this.url = HOST;
        this.retryResponseCodes = NetworkConstantsKt.getDEFAULT_RETRY_CODES();
        this.headers = this.headersFactory.create();
        this.postHeaders = this.headersFactory.createPostHeader();
    }

    public /* synthetic */ FileUploadRequest(StripeFileParams stripeFileParams, ApiRequest.Options options, AppInfo appInfo, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            appInfo = null;
        }
        if ((n & 8) != 0) {
            string = FileUploadRequest.Companion.createBoundary();
        }
        this(stripeFileParams, options, appInfo, string);
    }

    @NotNull
    protected final String getBoundary() {
        return this.boundary;
    }

    @Override
    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public Iterable<Integer> getRetryResponseCodes() {
        return this.retryResponseCodes;
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    @Nullable
    public Map<String, String> getPostHeaders() {
        return this.postHeaders;
    }

    @Override
    public void setPostHeaders(@Nullable Map<String, String> map) {
        this.postHeaders = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePostBody(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Closeable closeable = outputStream;
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter((Writer)it, true);
            Throwable throwable = null;
            try {
                PrintWriter writer = (PrintWriter)closeable2;
                boolean bl2 = false;
                this.writeString(writer, this.getPurposeContents());
                this.writeString(writer, this.getFileMetadata());
                this.writeFile(outputStream);
                writer.write(LINE_BREAK);
                writer.write("--" + this.boundary + "--");
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    protected final void writeString(@NotNull PrintWriter writer, @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        writer.write(StringsKt.replace$default((String)contents, (String)"\n", (String)LINE_BREAK, (boolean)false, (int)4, null));
        writer.flush();
    }

    protected final void writeFile(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ByteStreamsKt.copyTo$default((InputStream)new FileInputStream(this.fileParams.getFile$stripe_core_release()), (OutputStream)outputStream, (int)0, (int)2, null);
    }

    @NotNull
    public final String getFileMetadata() {
        String fileName = this.fileParams.getFile$stripe_core_release().getName();
        String probableContentType = URLConnection.guessContentTypeFromName(fileName);
        return StringsKt.trimIndent((String)("\n                --" + this.boundary + "\n                Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\n                Content-Type: " + probableContentType + "\n                Content-Transfer-Encoding: binary\n\n\n            "));
    }

    @NotNull
    public final String getPurposeContents() {
        return StringsKt.trimIndent((String)("\n                --" + this.boundary + "\n                Content-Disposition: form-data; name=\"purpose\"\n\n                " + this.fileParams.getPurpose$stripe_core_release().getCode() + "\n\n            "));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0085\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/core/networking/FileUploadRequest$Companion;", "", "<init>", "()V", "LINE_BREAK", "", "HOST", "createBoundary", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static final class Companion {
        private Companion() {
        }

        private final String createBoundary() {
            return String.valueOf(Random.Default.nextLong(0L, Long.MAX_VALUE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

