/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.StripeConnection;
import com.stripe.android.core.networking.StripeRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u0000 \f2\u00020\u0001:\u0003\n\u000b\fJ\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH&\u00a8\u0006\r"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory;", "", "create", "Lcom/stripe/android/core/networking/StripeConnection;", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "createForFile", "Ljava/io/File;", "outputFile", "ConnectionOpener", "Default", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface ConnectionFactory {
    public static final /* synthetic */ Companion Companion;

    @NotNull
    public StripeConnection<String> create(@NotNull StripeRequest var1) throws IOException, InvalidRequestException;

    @NotNull
    public StripeConnection<File> createForFile(@NotNull StripeRequest var1, @NotNull File var2) throws IOException, InvalidRequestException;

    static {
        Companion = com.stripe.android.core.networking.ConnectionFactory$Companion.$$INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$Companion;", "", "<init>", "()V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "stripe-core_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int CONNECT_TIMEOUT;
        private static final int READ_TIMEOUT;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
            READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(80L);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\rJ>\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052,\u0010\u0006\u001a(\u0012\u0004\u0012\u00020\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\b\fH&\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener;", "", "open", "Ljavax/net/ssl/HttpsURLConnection;", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "callback", "Lkotlin/Function2;", "Ljava/net/HttpURLConnection;", "Lkotlin/ParameterName;", "name", "", "Lkotlin/ExtensionFunctionType;", "Default", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ConnectionOpener {
        @NotNull
        public HttpsURLConnection open(@NotNull StripeRequest var1, @NotNull Function2<? super HttpURLConnection, ? super StripeRequest, Unit> var2);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072,\u0010\b\u001a(\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener$Default;", "Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener;", "<init>", "()V", "open", "Ljavax/net/ssl/HttpsURLConnection;", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "callback", "Lkotlin/Function2;", "Ljava/net/HttpURLConnection;", "Lkotlin/ParameterName;", "name", "", "Lkotlin/ExtensionFunctionType;", "stripe-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static final class Default
        implements ConnectionOpener {
            @NotNull
            public static final Default INSTANCE = new Default();

            private Default() {
            }

            @Override
            @NotNull
            public HttpsURLConnection open(@NotNull StripeRequest request, @NotNull Function2<? super HttpURLConnection, ? super StripeRequest, Unit> callback) {
                HttpsURLConnection httpsURLConnection;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                URLConnection uRLConnection = new URL(request.getUrl()).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
                HttpsURLConnection $this$open_u24lambda_u240 = httpsURLConnection = (HttpsURLConnection)uRLConnection;
                boolean bl = false;
                callback.invoke((Object)$this$open_u24lambda_u240, (Object)request);
                return httpsURLConnection;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$Default;", "Lcom/stripe/android/core/networking/ConnectionFactory;", "<init>", "()V", "connectionOpener", "Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener;", "getConnectionOpener", "()Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener;", "setConnectionOpener", "(Lcom/stripe/android/core/networking/ConnectionFactory$ConnectionOpener;)V", "create", "Lcom/stripe/android/core/networking/StripeConnection;", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "createForFile", "Ljava/io/File;", "outputFile", "openConnectionAndApplyFields", "Ljavax/net/ssl/HttpsURLConnection;", "originalRequest", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nConnectionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionFactory.kt\ncom/stripe/android/core/networking/ConnectionFactory$Default\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n216#2,2:101\n216#2,2:103\n1#3:105\n*S KotlinDebug\n*F\n+ 1 ConnectionFactory.kt\ncom/stripe/android/core/networking/ConnectionFactory$Default\n*L\n80#1:101,2\n86#1:103,2\n*E\n"})
    public static final class Default
    implements ConnectionFactory {
        @NotNull
        public static final Default INSTANCE = new Default();
        @NotNull
        private static volatile ConnectionOpener connectionOpener = ConnectionOpener.Default.INSTANCE;

        private Default() {
        }

        @NotNull
        public final ConnectionOpener getConnectionOpener() {
            return connectionOpener;
        }

        public final void setConnectionOpener(@NotNull ConnectionOpener connectionOpener) {
            Intrinsics.checkNotNullParameter((Object)connectionOpener, (String)"<set-?>");
            Default.connectionOpener = connectionOpener;
        }

        public /* synthetic */ StripeConnection create(StripeRequest request) throws IOException, InvalidRequestException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return new StripeConnection.Default(this.openConnectionAndApplyFields(request));
        }

        @Override
        @NotNull
        public StripeConnection<File> createForFile(@NotNull StripeRequest request, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            return new StripeConnection.FileConnection(this.openConnectionAndApplyFields(request), outputFile);
        }

        private final HttpsURLConnection openConnectionAndApplyFields(StripeRequest originalRequest) {
            return connectionOpener.open(originalRequest, (Function2<? super HttpURLConnection, ? super StripeRequest, Unit>)((Function2)Default::openConnectionAndApplyFields$lambda$3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit openConnectionAndApplyFields$lambda$3(HttpURLConnection $this$open, StripeRequest request) {
            Intrinsics.checkNotNullParameter((Object)$this$open, (String)"$this$open");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            $this$open.setConnectTimeout(com.stripe.android.core.networking.ConnectionFactory$Companion.CONNECT_TIMEOUT);
            $this$open.setReadTimeout(com.stripe.android.core.networking.ConnectionFactory$Companion.READ_TIMEOUT);
            $this$open.setUseCaches(request.getShouldCache());
            $this$open.setRequestMethod(request.getMethod().getCode());
            Map<String, String> $this$forEach$iv = request.getHeaders();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator.next();
                boolean bl = false;
                String key = entry2.getKey();
                String value = entry2.getValue();
                $this$open.setRequestProperty(key, value);
            }
            if (StripeRequest.Method.POST == request.getMethod()) {
                $this$open.setDoOutput(true);
                Map<String, String> map = request.getPostHeaders();
                if (map != null) {
                    Map<String, String> $this$forEach$iv2 = map;
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, String> element$iv2;
                        Map.Entry<String, String> entry = element$iv2 = iterator2.next();
                        boolean bl = false;
                        String key = entry.getKey();
                        String value = entry.getValue();
                        $this$open.setRequestProperty(key, value);
                    }
                }
                Closeable closeable = $this$open.getOutputStream();
                Throwable throwable = null;
                try {
                    OutputStream output = (OutputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)output);
                    request.writePostBody(output);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return Unit.INSTANCE;
        }
    }
}

