/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequest;
import com.stripe.android.core.networking.RequestHeadersFactory;
import com.stripe.android.core.utils.PluginDetector;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBS\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u00a2\u0006\u0004\b\f\u0010\rJ$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013*\u00020\u0011H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0013H\u0002J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0019\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestFactory;", "", "packageManager", "Landroid/content/pm/PackageManager;", "packageInfo", "Landroid/content/pm/PackageInfo;", "packageName", "", "publishableKeyProvider", "Ljavax/inject/Provider;", "networkTypeProvider", "pluginTypeProvider", "<init>", "(Landroid/content/pm/PackageManager;Landroid/content/pm/PackageInfo;Ljava/lang/String;Ljavax/inject/Provider;Ljavax/inject/Provider;Ljavax/inject/Provider;)V", "createRequest", "Lcom/stripe/android/core/networking/AnalyticsRequest;", "event", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "additionalParams", "", "createParams", "params", "standardParams", "networkType", "pluginType", "appDataParams", "appDataParams$stripe_core_release", "getAppName", "", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnalyticsRequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PackageManager packageManager;
    @Nullable
    private final PackageInfo packageInfo;
    @NotNull
    private final String packageName;
    @NotNull
    private final Provider<String> publishableKeyProvider;
    @NotNull
    private final Provider<String> networkTypeProvider;
    @NotNull
    private final Provider<String> pluginTypeProvider;
    @NotNull
    private static volatile UUID sessionId;
    @NotNull
    private static final String ANALYTICS_PREFIX = "analytics";
    @NotNull
    private static final String ANALYTICS_NAME = "stripe_android";
    @NotNull
    private static final String ANALYTICS_VERSION = "1.0";
    @NotNull
    private static final String DEVICE_TYPE;
    @NotNull
    public static final String ANALYTICS_UA = "analytics.stripe_android-1.0";
    @NotNull
    private static final Provider<String> PLUGIN_TYPE_PROVIDER;

    public AnalyticsRequestFactory(@Nullable PackageManager packageManager, @Nullable PackageInfo packageInfo, @NotNull String packageName, @NotNull Provider<String> publishableKeyProvider, @NotNull Provider<String> networkTypeProvider, @NotNull Provider<String> pluginTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(networkTypeProvider, (String)"networkTypeProvider");
        Intrinsics.checkNotNullParameter(pluginTypeProvider, (String)"pluginTypeProvider");
        this.packageManager = packageManager;
        this.packageInfo = packageInfo;
        this.packageName = packageName;
        this.publishableKeyProvider = publishableKeyProvider;
        this.networkTypeProvider = networkTypeProvider;
        this.pluginTypeProvider = pluginTypeProvider;
    }

    public /* synthetic */ AnalyticsRequestFactory(PackageManager packageManager, PackageInfo packageInfo, String string, Provider provider, Provider provider2, Provider provider3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            provider3 = PLUGIN_TYPE_PROVIDER;
        }
        this(packageManager, packageInfo, string, (Provider<String>)provider, (Provider<String>)provider2, provider3);
    }

    @NotNull
    public final AnalyticsRequest createRequest(@NotNull AnalyticsEvent event, @NotNull Map<String, ? extends Object> additionalParams) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
        return new AnalyticsRequest(MapsKt.plus(this.createParams(event), additionalParams), RequestHeadersFactory.Analytics.INSTANCE.create());
    }

    private final Map<String, Object> createParams(AnalyticsEvent event) {
        return MapsKt.plus((Map)MapsKt.plus(this.standardParams(), this.appDataParams$stripe_core_release()), this.params(event));
    }

    private final Map<String, String> params(AnalyticsEvent $this$params) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"event", (Object)$this$params.getEventName()));
    }

    private final Map<String, Object> standardParams() {
        Object object;
        Object object2;
        Pair[] pairArray = new Pair[10];
        pairArray[0] = TuplesKt.to((Object)"analytics_ua", (Object)ANALYTICS_UA);
        Object object3 = this;
        String string = "publishable_key";
        int n = 1;
        Pair[] pairArray2 = pairArray;
        try {
            AnalyticsRequestFactory $this$standardParams_u24lambda_u240 = object3;
            boolean bl = false;
            object2 = Result.constructor-impl((Object)((String)$this$standardParams_u24lambda_u240.publishableKeyProvider.get()));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object = object2;
        object2 = "pk_undefined";
        pairArray2[n] = TuplesKt.to((Object)string, (Object)(Result.isFailure-impl((Object)object3) ? object2 : object3));
        pairArray[2] = TuplesKt.to((Object)"os_name", (Object)Build.VERSION.CODENAME);
        pairArray[3] = TuplesKt.to((Object)"os_release", (Object)Build.VERSION.RELEASE);
        pairArray[4] = TuplesKt.to((Object)"os_version", (Object)Build.VERSION.SDK_INT);
        pairArray[5] = TuplesKt.to((Object)"device_type", (Object)DEVICE_TYPE);
        pairArray[6] = TuplesKt.to((Object)"bindings_version", (Object)"21.10.0");
        pairArray[7] = TuplesKt.to((Object)"is_development", (Object)false);
        pairArray[8] = TuplesKt.to((Object)"session_id", (Object)sessionId);
        pairArray[9] = TuplesKt.to((Object)"locale", (Object)Locale.getDefault().toString());
        return MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), this.networkType()), this.pluginType());
    }

    private final Map<String, String> networkType() {
        String string = (String)this.networkTypeProvider.get();
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String networkType = string;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"network_type", (Object)networkType));
    }

    private final Map<String, String> pluginType() {
        Object object;
        block3: {
            block2: {
                object = (String)this.pluginTypeProvider.get();
                if (object == null) break block2;
                String pluginType = object;
                boolean bl = false;
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"plugin_type", (Object)pluginType));
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    public final Map<String, Object> appDataParams$stripe_core_release() {
        Map map;
        if (this.packageManager != null && this.packageInfo != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"app_name", (Object)this.getAppName(this.packageInfo, this.packageManager)), TuplesKt.to((Object)"app_version", (Object)this.packageInfo.versionCode)};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final CharSequence getAppName(PackageInfo packageInfo, PackageManager packageManager) {
        CharSequence charSequence;
        PackageInfo packageInfo2 = packageInfo;
        CharSequence it = charSequence = packageInfo2 != null && (packageInfo2 = packageInfo2.applicationInfo) != null ? packageInfo2.loadLabel(packageManager) : null;
        boolean bl = false;
        CharSequence charSequence2 = it;
        CharSequence charSequence3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? charSequence : null;
        if (charSequence3 == null) {
            charSequence3 = this.packageName;
        }
        return charSequence3;
    }

    private static final String PLUGIN_TYPE_PROVIDER$lambda$3() {
        return PluginDetector.INSTANCE.getPluginType();
    }

    static {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        sessionId = uUID;
        DEVICE_TYPE = Build.MANUFACTURER + "_" + Build.BRAND + "_" + Build.MODEL;
        PLUGIN_TYPE_PROVIDER = AnalyticsRequestFactory::PLUGIN_TYPE_PROVIDER$lambda$3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestFactory$Companion;", "", "<init>", "()V", "value", "Ljava/util/UUID;", "sessionId", "getSessionId", "()Ljava/util/UUID;", "ANALYTICS_PREFIX", "", "ANALYTICS_NAME", "ANALYTICS_VERSION", "DEVICE_TYPE", "ANALYTICS_UA", "setSessionId", "", "id", "PLUGIN_TYPE_PROVIDER", "Ljavax/inject/Provider;", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UUID getSessionId() {
            return sessionId;
        }

        public final void setSessionId(@NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            sessionId = id;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

