/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.frauddetection;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.frauddetection.DefaultFraudDetectionDataStore;
import com.stripe.android.core.frauddetection.FraudDetectionData;
import com.stripe.android.core.frauddetection.FraudDetectionDataJsonParser;
import com.stripe.android.core.frauddetection.FraudDetectionDataStore;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/core/frauddetection/DefaultFraudDetectionDataStore;", "Lcom/stripe/android/core/frauddetection/FraudDetectionDataStore;", "context", "Landroid/content/Context;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Landroid/content/Context;Lkotlin/coroutines/CoroutineContext;)V", "prefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getPrefs", "()Landroid/content/SharedPreferences;", "prefs$delegate", "Lkotlin/Lazy;", "get", "Lcom/stripe/android/core/frauddetection/FraudDetectionData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "save", "", "fraudDetectionData", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DefaultFraudDetectionDataStore
implements FraudDetectionDataStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Lazy prefs$delegate;
    @NotNull
    private static final String PREF_FILE = "FraudDetectionDataStore";
    @NotNull
    private static final String KEY_DATA = "key_fraud_detection_data";

    public DefaultFraudDetectionDataStore(@NotNull Context context, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.workContext = workContext;
        this.prefs$delegate = LazyKt.lazy(() -> DefaultFraudDetectionDataStore.prefs_delegate$lambda$0(context));
    }

    public /* synthetic */ DefaultFraudDetectionDataStore(Context context, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        this(context, coroutineContext);
    }

    private final SharedPreferences getPrefs() {
        Lazy lazy = this.prefs$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @Override
    @Nullable
    public Object get(@NotNull Continuation<? super FraudDetectionData> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FraudDetectionData>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultFraudDetectionDataStore this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        CoroutineScope $this$withContext;
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = $this$withContext = (CoroutineScope)this.L$0;
                        DefaultFraudDetectionDataStore defaultFraudDetectionDataStore = this.this$0;
                        try {
                            boolean bl = false;
                            String string = DefaultFraudDetectionDataStore.access$getPrefs(defaultFraudDetectionDataStore).getString("key_fraud_detection_data", null);
                            if (string == null) {
                                string = "";
                            }
                            JSONObject json = new JSONObject(string);
                            Function0 timestampSupplier = () -> get.2.invokeSuspend$lambda$1$lambda$0(json);
                            object2 = Result.constructor-impl((Object)new FraudDetectionDataJsonParser((Function0<Long>)timestampSupplier).parse(json));
                        }
                        catch (Throwable throwable) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object3 = object2;
                        return Result.isFailure-impl((Object)object3) ? null : object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FraudDetectionData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final long invokeSuspend$lambda$1$lambda$0(JSONObject $json) {
                return $json.optLong("timestamp", -1L);
            }
        }), $completion);
    }

    @Override
    public void save(@NotNull FraudDetectionData fraudDetectionData) {
        Intrinsics.checkNotNullParameter((Object)fraudDetectionData, (String)"fraudDetectionData");
        this.getPrefs().edit().putString(KEY_DATA, fraudDetectionData.toJson().toString()).apply();
    }

    private static final SharedPreferences prefs_delegate$lambda$0(Context $context) {
        return $context.getSharedPreferences(PREF_FILE, 0);
    }

    public static final /* synthetic */ SharedPreferences access$getPrefs(DefaultFraudDetectionDataStore $this) {
        return $this.getPrefs();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/core/frauddetection/DefaultFraudDetectionDataStore$Companion;", "", "<init>", "()V", "PREF_FILE", "", "KEY_DATA", "stripe-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

