/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.strings;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.StringRes;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.core.strings.transformations.TransformOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B4\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0013\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J\u0016\u0010\r\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0005H\u00c2\u0003J:\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0015\b\u0002\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0005H\u00c6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0015H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u001b\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/core/strings/IdentifierResolvableString;", "Lcom/stripe/android/core/strings/ResolvableString;", "id", "", "transformations", "", "Lcom/stripe/android/core/strings/transformations/TransformOperation;", "args", "", "Lkotlinx/parcelize/RawValue;", "(ILjava/util/List;Ljava/util/List;)V", "component1", "component2", "component3", "copy", "describeContents", "equals", "", "other", "hashCode", "resolve", "", "context", "Landroid/content/Context;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe-core_release"})
@Parcelize
@SourceDebugExtension(value={"SMAP\nIdentifierResolvableString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentifierResolvableString.kt\ncom/stripe/android/core/strings/IdentifierResolvableString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,24:1\n1789#2,3:25\n*S KotlinDebug\n*F\n+ 1 IdentifierResolvableString.kt\ncom/stripe/android/core/strings/IdentifierResolvableString\n*L\n17#1:25,3\n*E\n"})
public final class IdentifierResolvableString
implements ResolvableString {
    private final int id;
    @NotNull
    private final List<TransformOperation> transformations;
    @NotNull
    private final List<Object> args;
    @NotNull
    public static final Parcelable.Creator<IdentifierResolvableString> CREATOR;

    public IdentifierResolvableString(@StringRes int id, @NotNull List<? extends TransformOperation> transformations, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter(transformations, (String)"transformations");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.id = id;
        this.transformations = transformations;
        this.args = args;
    }

    public /* synthetic */ IdentifierResolvableString(int n, List list, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(n, list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String resolve(@NotNull Context context) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable iterable = this.transformations;
        Object[] objectArray = ResolvableStringUtilsKt.resolveArgs(context, this.args);
        String string = context.getString(this.id, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String initial$iv = string;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transformation;
            TransformOperation transformOperation = (TransformOperation)element$iv;
            String currentValue = accumulator$iv;
            boolean bl = false;
            accumulator$iv = transformation.transform(currentValue);
        }
        return accumulator$iv;
    }

    private final int component1() {
        return this.id;
    }

    private final List<TransformOperation> component2() {
        return this.transformations;
    }

    private final List<Object> component3() {
        return this.args;
    }

    @NotNull
    public final IdentifierResolvableString copy(@StringRes int id, @NotNull List<? extends TransformOperation> transformations, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter(transformations, (String)"transformations");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new IdentifierResolvableString(id, transformations, args);
    }

    public static /* synthetic */ IdentifierResolvableString copy$default(IdentifierResolvableString identifierResolvableString, int n, List list, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = identifierResolvableString.id;
        }
        if ((n2 & 2) != 0) {
            list = identifierResolvableString.transformations;
        }
        if ((n2 & 4) != 0) {
            list2 = identifierResolvableString.args;
        }
        return identifierResolvableString.copy(n, list, list2);
    }

    @NotNull
    public String toString() {
        return "IdentifierResolvableString(id=" + this.id + ", transformations=" + this.transformations + ", args=" + this.args + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.id);
        result = result * 31 + ((Object)this.transformations).hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdentifierResolvableString)) {
            return false;
        }
        IdentifierResolvableString identifierResolvableString = (IdentifierResolvableString)other;
        if (this.id != identifierResolvableString.id) {
            return false;
        }
        if (!Intrinsics.areEqual(this.transformations, identifierResolvableString.transformations)) {
            return false;
        }
        return Intrinsics.areEqual(this.args, identifierResolvableString.args);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.id);
        List<Object> list = this.transformations;
        out.writeInt(list.size());
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            out.writeParcelable((Parcelable)iterator.next(), flags);
        }
        list = this.args;
        out.writeInt(list.size());
        iterator = list.iterator();
        while (iterator.hasNext()) {
            out.writeValue(iterator.next());
        }
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<IdentifierResolvableString> {
            @NotNull
            public final IdentifierResolvableString[] newArray(int size) {
                return new IdentifierResolvableString[size];
            }

            @NotNull
            public final IdentifierResolvableString createFromParcel(@NotNull Parcel parcel) {
                int n;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n2 = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n2);
                int n3 = parcel.readInt();
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readParcelable(IdentifierResolvableString.class.getClassLoader()));
                }
                List list = arrayList;
                n2 = parcel.readInt();
                arrayList = new ArrayList(n2);
                List list2 = list;
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readValue(IdentifierResolvableString.class.getClassLoader()));
                }
                List list3 = arrayList;
                List list4 = list2;
                int n4 = n3;
                return new IdentifierResolvableString(n4, list4, list3);
            }
        }
        CREATOR = new Creator();
    }
}

