/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000b\u0010\f\u001a\u0004\u0018\u00010\rH\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/core/networking/NetworkTypeDetector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "(Landroid/net/ConnectivityManager;)V", "determineMobileNetworkType", "Lcom/stripe/android/core/networking/NetworkTypeDetector$NetworkType;", "subtype", "", "invoke", "", "NetworkType", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NetworkTypeDetector {
    @NotNull
    private final ConnectivityManager connectivityManager;

    private NetworkTypeDetector(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    public NetworkTypeDetector(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this((ConnectivityManager)object);
    }

    @Nullable
    public final String invoke() {
        NetworkType networkType;
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            return null;
        }
        switch (networkInfo.getType()) {
            case 1: {
                networkType = NetworkType.WiFi;
                break;
            }
            case 0: {
                networkType = this.determineMobileNetworkType(networkInfo.getSubtype());
                break;
            }
            default: {
                networkType = NetworkType.Unknown;
            }
        }
        NetworkType networkType2 = networkType;
        return networkType2.getValue();
    }

    private final NetworkType determineMobileNetworkType(int subtype) {
        NetworkType networkType;
        switch (subtype) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                networkType = NetworkType.Mobile2G;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                networkType = NetworkType.Mobile3G;
                break;
            }
            case 13: 
            case 18: 
            case 19: {
                networkType = NetworkType.Mobile4G;
                break;
            }
            case 20: {
                networkType = NetworkType.Mobile5G;
                break;
            }
            default: {
                networkType = NetworkType.Unknown;
            }
        }
        return networkType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/stripe/android/core/networking/NetworkTypeDetector$NetworkType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "WiFi", "Mobile2G", "Mobile3G", "Mobile4G", "Mobile5G", "Unknown", "stripe-core_release"})
    private static final class NetworkType
    extends Enum<NetworkType> {
        @NotNull
        private final String value;
        public static final /* enum */ NetworkType WiFi = new NetworkType("Wi-Fi");
        public static final /* enum */ NetworkType Mobile2G = new NetworkType("2G");
        public static final /* enum */ NetworkType Mobile3G = new NetworkType("3G");
        public static final /* enum */ NetworkType Mobile4G = new NetworkType("4G");
        public static final /* enum */ NetworkType Mobile5G = new NetworkType("5G");
        public static final /* enum */ NetworkType Unknown = new NetworkType("unknown");
        private static final /* synthetic */ NetworkType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NetworkType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static NetworkType[] values() {
            return (NetworkType[])$VALUES.clone();
        }

        public static NetworkType valueOf(String value) {
            return Enum.valueOf(NetworkType.class, value);
        }

        @NotNull
        public static EnumEntries<NetworkType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = networkTypeArray = new NetworkType[]{NetworkType.WiFi, NetworkType.Mobile2G, NetworkType.Mobile3G, NetworkType.Mobile4G, NetworkType.Mobile5G, NetworkType.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

