/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class Token
implements StripePaymentSource {
    public static final String TYPE_CARD = "card";
    public static final String TYPE_BANK_ACCOUNT = "bank_account";
    public static final String TYPE_PII = "pii";
    public static final String TYPE_ACCOUNT = "account";
    public static final String TYPE_CVC_UPDATE = "cvc_update";
    private static final String FIELD_BANK_ACCOUNT = "bank_account";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ID = "id";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USED = "used";
    @NonNull
    private final String mId;
    @NonNull
    private final String mType;
    @NonNull
    private final Date mCreated;
    private final boolean mLivemode;
    private final boolean mUsed;
    @Nullable
    private final BankAccount mBankAccount;
    @Nullable
    private final Card mCard;

    public Token(@NonNull String id2, boolean livemode, @NonNull Date created, @Nullable Boolean used, @Nullable Card card) {
        this.mId = id2;
        this.mType = "card";
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = card;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mBankAccount = null;
    }

    public Token(@NonNull String id2, boolean livemode, @NonNull Date created, @Nullable Boolean used, @NonNull BankAccount bankAccount) {
        this.mId = id2;
        this.mType = "bank_account";
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = null;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mBankAccount = bankAccount;
    }

    public Token(@NonNull String id2, @NonNull String type, boolean livemode, @NonNull Date created, @Nullable Boolean used) {
        this.mId = id2;
        this.mType = type;
        this.mCreated = created;
        this.mCard = null;
        this.mBankAccount = null;
        this.mUsed = Boolean.TRUE.equals(used);
        this.mLivemode = livemode;
    }

    @NonNull
    public Date getCreated() {
        return this.mCreated;
    }

    @Override
    @NonNull
    public String getId() {
        return this.mId;
    }

    public boolean getLivemode() {
        return this.mLivemode;
    }

    public boolean getUsed() {
        return this.mUsed;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @Nullable
    public Card getCard() {
        return this.mCard;
    }

    @Nullable
    public BankAccount getBankAccount() {
        return this.mBankAccount;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mId, this.mType, this.mCreated, this.mLivemode, this.mUsed, this.mBankAccount, this.mCard);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof Token && this.typedEquals((Token)obj);
    }

    private boolean typedEquals(@NonNull Token token) {
        return ObjectUtils.equals(this.mId, token.mId) && ObjectUtils.equals(this.mType, token.mType) && ObjectUtils.equals(this.mCreated, token.mCreated) && this.mLivemode == token.mLivemode && this.mUsed == token.mUsed && ObjectUtils.equals(this.mBankAccount, token.mBankAccount) && ObjectUtils.equals(this.mCard, token.mCard);
    }

    @Nullable
    public static Token fromString(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            JSONObject tokenObject = new JSONObject(jsonString);
            return Token.fromJson(tokenObject);
        }
        catch (JSONException exception) {
            return null;
        }
    }

    @Nullable
    public static Token fromJson(@Nullable JSONObject jsonObject) {
        Token token;
        if (jsonObject == null) {
            return null;
        }
        String tokenId = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long createdTimeStamp = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        Boolean liveModeOpt = StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE);
        String tokenType = Token.asTokenType(StripeJsonUtils.optString(jsonObject, FIELD_TYPE));
        Boolean usedOpt = StripeJsonUtils.optBoolean(jsonObject, FIELD_USED);
        if (tokenId == null || createdTimeStamp == null || liveModeOpt == null) {
            return null;
        }
        boolean used = Boolean.TRUE.equals(usedOpt);
        boolean liveMode = Boolean.TRUE.equals(liveModeOpt);
        Date date = new Date(createdTimeStamp * 1000L);
        if ("bank_account".equals(tokenType)) {
            JSONObject bankAccountObject = jsonObject.optJSONObject("bank_account");
            if (bankAccountObject == null) {
                return null;
            }
            token = new Token(tokenId, liveMode, date, (Boolean)used, BankAccount.fromJson(bankAccountObject));
        } else if ("card".equals(tokenType)) {
            JSONObject cardObject = jsonObject.optJSONObject("card");
            if (cardObject == null) {
                return null;
            }
            token = new Token(tokenId, liveMode, date, (Boolean)used, Card.fromJson(cardObject));
        } else {
            token = TYPE_PII.equals(tokenType) || TYPE_ACCOUNT.equals(tokenType) || TYPE_CVC_UPDATE.equals(tokenType) ? new Token(tokenId, tokenType, liveMode, date, used) : null;
        }
        return token;
    }

    @Nullable
    private static String asTokenType(@Nullable String possibleTokenType) {
        if (possibleTokenType == null || StripeTextUtils.isEmpty(possibleTokenType.trim())) {
            return null;
        }
        if ("card".equals(possibleTokenType)) {
            return "card";
        }
        if ("bank_account".equals(possibleTokenType)) {
            return "bank_account";
        }
        if (TYPE_PII.equals(possibleTokenType)) {
            return TYPE_PII;
        }
        if (TYPE_ACCOUNT.equals(possibleTokenType)) {
            return TYPE_ACCOUNT;
        }
        if (TYPE_CVC_UPDATE.equals(possibleTokenType)) {
            return TYPE_CVC_UPDATE;
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TokenType {
    }
}

