/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.TextInputLayout;
import android.util.AttributeSet;
import com.stripe.android.utils.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class IconTextInputLayout
extends TextInputLayout {
    private static final Set<String> BOUNDS_FIELD_NAMES = new HashSet<String>(Arrays.asList("mCollapsedBounds", "collapsedBounds"));
    private static final Set<String> TEXT_FIELD_NAMES = new HashSet<String>(Arrays.asList("mCollapsingTextHelper", "collapsingTextHelper"));
    private static final Set<String> RECALCULATE_METHOD_NAMES = Collections.singleton("recalculate");
    @VisibleForTesting
    private final Object mCollapsingTextHelper = ClassUtils.getInternalObject(TextInputLayout.class, TEXT_FIELD_NAMES, (Object)this);
    @VisibleForTesting
    private final Rect mBounds;
    @VisibleForTesting
    private final Method mRecalculateMethod;

    public IconTextInputLayout(Context context) {
        this(context, null);
    }

    public IconTextInputLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconTextInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.mCollapsingTextHelper == null) {
            this.mBounds = null;
            this.mRecalculateMethod = null;
        } else {
            this.mBounds = (Rect)ClassUtils.getInternalObject(this.mCollapsingTextHelper.getClass(), BOUNDS_FIELD_NAMES, this.mCollapsingTextHelper);
            this.mRecalculateMethod = ClassUtils.findMethod(this.mCollapsingTextHelper.getClass(), RECALCULATE_METHOD_NAMES);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.adjustBounds();
    }

    private void adjustBounds() {
        if (this.mCollapsingTextHelper == null || this.getEditText() == null) {
            return;
        }
        try {
            this.mBounds.left = this.getEditText().getLeft() + this.getEditText().getPaddingStart();
            this.mRecalculateMethod.invoke(this.mCollapsingTextHelper, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    boolean hasObtainedCollapsingTextHelper() {
        return this.mCollapsingTextHelper != null && this.mBounds != null && this.mRecalculateMethod != null;
    }
}

