/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeIntentParams;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public final class SetupIntentParams
implements StripeIntentParams {
    @NonNull
    private final String mClientSecret;
    @Nullable
    private final String mReturnUrl;
    @Nullable
    private final String mPaymentMethodId;

    private SetupIntentParams(@NonNull String clientSecret, @Nullable String returnUrl, @Nullable String paymentMethodId) {
        this.mClientSecret = clientSecret;
        this.mReturnUrl = returnUrl;
        this.mPaymentMethodId = paymentMethodId;
    }

    private SetupIntentParams(@NonNull String clientSecret) {
        this.mClientSecret = clientSecret;
        this.mReturnUrl = null;
        this.mPaymentMethodId = null;
    }

    @NonNull
    public static SetupIntentParams createConfirmParams(@NonNull String paymentMethodId, @NonNull String clientSecret, @NonNull String returnUrl) {
        return new SetupIntentParams(clientSecret, returnUrl, paymentMethodId);
    }

    @NonNull
    public static SetupIntentParams createRetrieveParams(@NonNull String clientSecret) {
        return new SetupIntentParams(clientSecret);
    }

    @Override
    @NonNull
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        if (this.mPaymentMethodId != null) {
            ((AbstractMap)networkReadyMap).put("payment_method", this.mPaymentMethodId);
        }
        if (this.mReturnUrl != null) {
            ((AbstractMap)networkReadyMap).put("return_url", this.mReturnUrl);
        }
        ((AbstractMap)networkReadyMap).put("client_secret", this.mClientSecret);
        return networkReadyMap;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SetupIntentParams && this.typedEquals((SetupIntentParams)obj);
    }

    private boolean typedEquals(@NonNull SetupIntentParams setupIntentParams) {
        return ObjectUtils.equals(this.mReturnUrl, setupIntentParams.mReturnUrl) && ObjectUtils.equals(this.mClientSecret, setupIntentParams.mClientSecret) && ObjectUtils.equals(this.mPaymentMethodId, setupIntentParams.mPaymentMethodId);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mReturnUrl, this.mClientSecret, this.mPaymentMethodId);
    }
}

