/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeTextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class LoggingUtils {
    static final String UNKNOWN = "unknown";
    static final String NO_CONTEXT = "no_context";
    static final String EVENT_TOKEN_CREATION = "token_creation";
    static final String EVENT_ADD_PAYMENT_METHOD = "add_payment_method";
    static final String EVENT_ATTACH_PAYMENT_METHOD = "attach_payment_method";
    static final String EVENT_DETACH_PAYMENT_METHOD = "detach_payment_method";
    static final String EVENT_SOURCE_CREATION = "source_creation";
    static final String EVENT_ADD_SOURCE = "add_source";
    static final String EVENT_DEFAULT_SOURCE = "default_source";
    static final String EVENT_DELETE_SOURCE = "delete_source";
    static final String EVENT_SET_SHIPPING_INFO = "set_shipping_info";
    static final String EVENT_CONFIRM_PAYMENT_INTENT = "payment_intent_confirmation";
    static final String EVENT_RETRIEVE_PAYMENT_INTENT = "payment_intent_retrieval";
    static final String FIELD_PRODUCT_USAGE = "product_usage";
    static final String FIELD_ANALYTICS_UA = "analytics_ua";
    static final String FIELD_APP_NAME = "app_name";
    static final String FIELD_APP_VERSION = "app_version";
    static final String FIELD_BINDINGS_VERSION = "bindings_version";
    static final String FIELD_DEVICE_TYPE = "device_type";
    static final String FIELD_EVENT = "event";
    static final String FIELD_OS_NAME = "os_name";
    static final String FIELD_OS_RELEASE = "os_release";
    static final String FIELD_OS_VERSION = "os_version";
    static final String FIELD_PUBLISHABLE_KEY = "publishable_key";
    static final String FIELD_SOURCE_TYPE = "source_type";
    static final String FIELD_TOKEN_TYPE = "token_type";
    static final Set<String> VALID_PARAM_FIELDS = new HashSet<String>();
    private static final String ANALYTICS_PREFIX = "analytics";
    private static final String ANALYTICS_NAME = "stripe_android";
    private static final String ANALYTICS_VERSION = "1.0";
    @Nullable
    private final PackageManager mPackageManager;
    @Nullable
    private final String mPackageName;

    LoggingUtils(@NonNull Context context) {
        this(context.getPackageManager(), context.getPackageName());
    }

    @VisibleForTesting
    LoggingUtils(@Nullable PackageManager packageManager, @Nullable String packageName) {
        this.mPackageManager = packageManager;
        this.mPackageName = packageName;
    }

    @NonNull
    Map<String, Object> getTokenCreationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @Nullable String tokenType) {
        return this.getEventLoggingParams(productUsageTokens, null, tokenType, publishableApiKey, EVENT_TOKEN_CREATION);
    }

    @NonNull
    Map<String, Object> getPaymentMethodCreationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableApiKey, EVENT_ADD_PAYMENT_METHOD);
    }

    @NonNull
    Map<String, Object> getSourceCreationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @NonNull String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableApiKey, EVENT_SOURCE_CREATION);
    }

    @NonNull
    Map<String, Object> getAddSourceParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey, @NonNull String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableKey, EVENT_ADD_SOURCE);
    }

    @NonNull
    Map<String, Object> getDeleteSourceParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableKey, EVENT_DELETE_SOURCE);
    }

    @NonNull
    Map<String, Object> getAttachPaymentMethodParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableKey, EVENT_ATTACH_PAYMENT_METHOD);
    }

    @NonNull
    Map<String, Object> getDetachPaymentMethodParams(@Nullable List<String> productUsageTokens, @NonNull String publishableKey) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableKey, EVENT_DETACH_PAYMENT_METHOD);
    }

    @NonNull
    Map<String, Object> getPaymentIntentConfirmationParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey, @Nullable String sourceType) {
        return this.getEventLoggingParams(productUsageTokens, sourceType, null, publishableApiKey, EVENT_CONFIRM_PAYMENT_INTENT);
    }

    @NonNull
    Map<String, Object> getPaymentIntentRetrieveParams(@Nullable List<String> productUsageTokens, @NonNull String publishableApiKey) {
        return this.getEventLoggingParams(productUsageTokens, null, null, publishableApiKey, EVENT_RETRIEVE_PAYMENT_INTENT);
    }

    @NonNull
    Map<String, Object> getEventLoggingParams(@Nullable List<String> productUsageTokens, @Nullable String sourceType, @Nullable String tokenType, @NonNull String publishableApiKey, @NonNull String eventName) {
        HashMap<String, Object> paramsObject = new HashMap<String, Object>();
        paramsObject.put(FIELD_ANALYTICS_UA, LoggingUtils.getAnalyticsUa());
        paramsObject.put(FIELD_EVENT, LoggingUtils.getEventParamName(eventName));
        paramsObject.put(FIELD_PUBLISHABLE_KEY, publishableApiKey);
        paramsObject.put(FIELD_OS_NAME, Build.VERSION.CODENAME);
        paramsObject.put(FIELD_OS_RELEASE, Build.VERSION.RELEASE);
        paramsObject.put(FIELD_OS_VERSION, Build.VERSION.SDK_INT);
        paramsObject.put(FIELD_DEVICE_TYPE, LoggingUtils.getDeviceLoggingString());
        paramsObject.put(FIELD_BINDINGS_VERSION, "9.3.5");
        this.addNameAndVersion(paramsObject);
        if (productUsageTokens != null) {
            paramsObject.put(FIELD_PRODUCT_USAGE, productUsageTokens);
        }
        if (sourceType != null) {
            paramsObject.put(FIELD_SOURCE_TYPE, sourceType);
        }
        if (tokenType != null) {
            paramsObject.put(FIELD_TOKEN_TYPE, tokenType);
        } else if (sourceType == null) {
            paramsObject.put(FIELD_TOKEN_TYPE, UNKNOWN);
        }
        return paramsObject;
    }

    void addNameAndVersion(@NonNull Map<String, Object> paramsObject) {
        if (this.mPackageManager != null) {
            try {
                String nameString;
                PackageInfo info = this.mPackageManager.getPackageInfo(this.mPackageName, 0);
                if (info.applicationInfo != null) {
                    CharSequence name = info.applicationInfo.loadLabel(this.mPackageManager);
                    nameString = name != null ? name.toString() : null;
                    paramsObject.put(FIELD_APP_NAME, nameString);
                } else {
                    nameString = null;
                }
                if (StripeTextUtils.isBlank(nameString)) {
                    paramsObject.put(FIELD_APP_NAME, info.packageName);
                }
                paramsObject.put(FIELD_APP_VERSION, info.versionCode);
            }
            catch (PackageManager.NameNotFoundException nameNotFound) {
                paramsObject.put(FIELD_APP_NAME, UNKNOWN);
                paramsObject.put(FIELD_APP_VERSION, UNKNOWN);
            }
        } else {
            paramsObject.put(FIELD_APP_NAME, NO_CONTEXT);
            paramsObject.put(FIELD_APP_VERSION, NO_CONTEXT);
        }
    }

    @NonNull
    private static String getDeviceLoggingString() {
        return Build.MANUFACTURER + '_' + Build.BRAND + '_' + Build.MODEL;
    }

    @NonNull
    static String getAnalyticsUa() {
        return "analytics.stripe_android-1.0";
    }

    @NonNull
    static String getEventParamName(@NonNull String eventName) {
        return "stripe_android." + eventName;
    }

    static {
        VALID_PARAM_FIELDS.add(FIELD_ANALYTICS_UA);
        VALID_PARAM_FIELDS.add(FIELD_APP_NAME);
        VALID_PARAM_FIELDS.add(FIELD_APP_VERSION);
        VALID_PARAM_FIELDS.add(FIELD_BINDINGS_VERSION);
        VALID_PARAM_FIELDS.add(FIELD_DEVICE_TYPE);
        VALID_PARAM_FIELDS.add(FIELD_EVENT);
        VALID_PARAM_FIELDS.add(FIELD_OS_VERSION);
        VALID_PARAM_FIELDS.add(FIELD_OS_NAME);
        VALID_PARAM_FIELDS.add(FIELD_OS_RELEASE);
        VALID_PARAM_FIELDS.add(FIELD_PRODUCT_USAGE);
        VALID_PARAM_FIELDS.add(FIELD_PUBLISHABLE_KEY);
        VALID_PARAM_FIELDS.add(FIELD_SOURCE_TYPE);
        VALID_PARAM_FIELDS.add(FIELD_TOKEN_TYPE);
    }
}

