/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

class RequestExecutor {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    @NonNull
    private final ConnectionFactory mConnectionFactory = new ConnectionFactory();

    RequestExecutor() {
    }

    @NonNull
    StripeResponse execute(@NonNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int responseCode = conn.getResponseCode();
            String responseBody = responseCode >= 200 && responseCode < 300 ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(responseCode, responseBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            throw this.createApiConnectionException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    int executeAndForget(@NonNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int n = conn.getResponseCode();
            return n;
        }
        catch (IOException e) {
            throw this.createApiConnectionException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Nullable
    private String getResponseBody(@Nullable InputStream responseStream) throws IOException {
        if (responseStream == null) {
            return null;
        }
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }

    @NonNull
    private APIConnectionException createApiConnectionException(@NonNull Exception e) {
        return new APIConnectionException(String.format(Locale.ENGLISH, "IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", StripeApiHandler.getTokensUrl(), e.getMessage()), e);
    }

    static class ConnectionFactory {
        private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();

        ConnectionFactory() {
        }

        @NonNull
        private HttpURLConnection create(@NonNull StripeRequest request) throws IOException, InvalidRequestException {
            URL stripeURL = new URL(request.getUrl());
            HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(80000);
            conn.setUseCaches(false);
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
            }
            conn.setRequestMethod(request.method.code);
            if (StripeRequest.Method.POST == request.method) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", request.getContentType());
                try (OutputStream output = conn.getOutputStream();){
                    output.write(this.getRequestOutputBytes(request));
                }
            }
            return conn;
        }

        @NonNull
        byte[] getRequestOutputBytes(@NonNull StripeRequest request) throws InvalidRequestException {
            try {
                return request.getOutputBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Unable to encode parameters to " + CHARSET + ". Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
            }
        }
    }
}

