/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StripeJsonUtils {
    private static final String EMPTY = "";
    private static final String NULL = "null";

    @Nullable
    static Boolean optBoolean(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optBoolean(fieldName);
    }

    @Nullable
    static Integer optInteger(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optInt(fieldName);
    }

    @Nullable
    static Long optLong(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        if (!jsonObject.has(fieldName)) {
            return null;
        }
        return jsonObject.optLong(fieldName);
    }

    @Nullable
    public static String optString(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        return StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
    }

    @Nullable
    @Size(value=2L)
    static String optCountryCode(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        String value = StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
        if (value != null && value.length() == 2) {
            return value;
        }
        return null;
    }

    @Nullable
    @Size(value=3L)
    static String optCurrency(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        String value = StripeJsonUtils.nullIfNullOrEmpty(jsonObject.optString(fieldName));
        if (value != null && value.length() == 3) {
            return value;
        }
        return null;
    }

    @Nullable
    static Map<String, Object> optMap(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        JSONObject foundObject = jsonObject.optJSONObject(fieldName);
        if (foundObject == null) {
            return null;
        }
        return StripeJsonUtils.jsonObjectToMap(foundObject);
    }

    @Nullable
    static Map<String, String> optHash(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String fieldName) {
        JSONObject foundObject = jsonObject.optJSONObject(fieldName);
        if (foundObject == null) {
            return null;
        }
        return StripeJsonUtils.jsonObjectToStringMap(foundObject);
    }

    @Nullable
    static Map<String, Object> jsonObjectToMap(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null) continue;
            if (value instanceof JSONObject) {
                ((AbstractMap)map).put(key, StripeJsonUtils.jsonObjectToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                ((AbstractMap)map).put(key, StripeJsonUtils.jsonArrayToList((JSONArray)value));
                continue;
            }
            ((AbstractMap)map).put(key, value);
        }
        return map;
    }

    @Nullable
    static Map<String, String> jsonObjectToStringMap(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null) continue;
            map.put(key, value.toString());
        }
        return map;
    }

    @Nullable
    static List<Object> jsonArrayToList(@Nullable JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                Object ob = jsonArray.get(i);
                if (ob instanceof JSONArray) {
                    objectList.add(StripeJsonUtils.jsonArrayToList((JSONArray)ob));
                    continue;
                }
                if (ob instanceof JSONObject) {
                    Map<String, Object> objectMap = StripeJsonUtils.jsonObjectToMap((JSONObject)ob);
                    if (objectMap == null) continue;
                    objectList.add(objectMap);
                    continue;
                }
                if (NULL.equals(ob)) continue;
                objectList.add(ob);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return objectList;
    }

    @Nullable
    static String nullIfNullOrEmpty(@Nullable String possibleNull) {
        return NULL.equals(possibleNull) || EMPTY.equals(possibleNull) ? null : possibleNull;
    }
}

