/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.utils.ObjectUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class FingerprintRequest
extends StripeRequest {
    private static final String MIME_TYPE = "application/json";
    private static final String URL = "https://m.stripe.com/4";
    @NonNull
    private final String guid;

    FingerprintRequest(@NonNull Map<String, Object> params, @NonNull String guid) {
        super(StripeRequest.Method.POST, URL, params, MIME_TYPE);
        this.guid = guid;
    }

    @Override
    @NonNull
    Map<String, String> getHeaders() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Cookie", "m=" + this.guid);
        return props;
    }

    @Override
    @NonNull
    byte[] getOutputBytes() throws UnsupportedEncodingException, InvalidRequestException {
        JSONObject jsonData = FingerprintRequest.mapToJsonObject(this.params);
        if (jsonData == null) {
            throw new InvalidRequestException("Unable to create JSON data from parameters. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, null);
        }
        return jsonData.toString().getBytes("UTF-8");
    }

    public int hashCode() {
        return ObjectUtils.hash(this.getBaseHashCode(), this.guid);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof FingerprintRequest && this.typedEquals((FingerprintRequest)obj);
    }

    private boolean typedEquals(@NonNull FingerprintRequest obj) {
        return super.typedEquals(obj) && ObjectUtils.equals(this.guid, obj.guid);
    }

    @Nullable
    private static JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)FingerprintRequest.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)FingerprintRequest.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    private static JSONArray listToJsonArray(@Nullable List<?> values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)FingerprintRequest.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)FingerprintRequest.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }
}

