/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.ViewUtils;

class ShippingMethodView
extends RelativeLayout {
    @NonNull
    private final TextView mLabel;
    @NonNull
    private final TextView mDetail;
    @NonNull
    private final TextView mAmount;
    @NonNull
    private final ImageView mCheckmark;
    @ColorInt
    private final int mSelectedColorInt;
    @ColorInt
    private final int mUnselectedTextColorSecondaryInt;
    @ColorInt
    private final int mUnselectedTextColorPrimaryInt;

    ShippingMethodView(@NonNull Context context) {
        this(context, null);
    }

    ShippingMethodView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    ShippingMethodView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ShippingMethodView.inflate((Context)context, (int)R.layout.shipping_method_view, (ViewGroup)this);
        this.mLabel = (TextView)this.findViewById(R.id.tv_label_smv);
        this.mDetail = (TextView)this.findViewById(R.id.tv_detail_smv);
        this.mAmount = (TextView)this.findViewById(R.id.tv_amount_smv);
        this.mCheckmark = (ImageView)this.findViewById(R.id.iv_selected_icon);
        int rawSelectedColorInt = ViewUtils.getThemeAccentColor((Context)context).data;
        int rawUselectedTextColorPrimaryInt = ViewUtils.getThemeTextColorPrimary((Context)context).data;
        int rawUnselectedTextColorSecondaryInt = ViewUtils.getThemeTextColorSecondary((Context)context).data;
        this.mSelectedColorInt = ViewUtils.isColorTransparent(rawSelectedColorInt) ? ContextCompat.getColor((Context)context, (int)R.color.accent_color_default) : rawSelectedColorInt;
        this.mUnselectedTextColorPrimaryInt = ViewUtils.isColorTransparent(rawUselectedTextColorPrimaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.color_text_unselected_primary_default) : rawUselectedTextColorPrimaryInt;
        this.mUnselectedTextColorSecondaryInt = ViewUtils.isColorTransparent(rawUnselectedTextColorSecondaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.color_text_unselected_secondary_default) : rawUnselectedTextColorSecondaryInt;
        this.initView();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.mLabel.setTextColor(this.mSelectedColorInt);
            this.mDetail.setTextColor(this.mSelectedColorInt);
            this.mAmount.setTextColor(this.mSelectedColorInt);
            this.mCheckmark.setVisibility(0);
        } else {
            this.mLabel.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mDetail.setTextColor(this.mUnselectedTextColorSecondaryInt);
            this.mAmount.setTextColor(this.mUnselectedTextColorPrimaryInt);
            this.mCheckmark.setVisibility(4);
        }
    }

    private void initView() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(16);
        int height = this.getResources().getDimensionPixelSize(R.dimen.shipping_method_view_height);
        params.height = ViewUtils.getPxFromDp(this.getContext(), height);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    void setShippingMethod(@NonNull ShippingMethod shippingMethod) {
        this.mLabel.setText((CharSequence)shippingMethod.getLabel());
        this.mDetail.setText((CharSequence)shippingMethod.getDetail());
        this.mAmount.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(shippingMethod.getAmount(), shippingMethod.getCurrency(), this.getContext().getString(R.string.price_free)));
    }
}

