/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.StripeActivity;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class AddPaymentMethodActivity
extends StripeActivity {
    public static final String TOKEN_ADD_PAYMENT_METHOD_ACTIVITY = "AddPaymentMethodActivity";
    public static final String EXTRA_NEW_PAYMENT_METHOD = "new_payment_method";
    public static final String EXTRA_SHOULD_REQUIRE_POSTAL_CODE = "require_postal";
    static final String EXTRA_PROXY_DELAY = "proxy_delay";
    static final String EXTRA_UPDATE_CUSTOMER = "update_customer";
    @Nullable
    private CardMultilineWidget mCardMultilineWidget;
    @Nullable
    private Stripe mStripe;
    private boolean mStartedFromPaymentSession;
    private boolean mUpdatesCustomer;

    @NonNull
    public static Intent newIntent(@NonNull Context context, boolean shouldRequirePostalCode, boolean updatesCustomer) {
        return new Intent(context, AddPaymentMethodActivity.class).putExtra(EXTRA_SHOULD_REQUIRE_POSTAL_CODE, shouldRequirePostalCode).putExtra(EXTRA_UPDATE_CUSTOMER, updatesCustomer);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mStripe = new Stripe(this.getApplicationContext(), PaymentConfiguration.getInstance().getPublishableKey());
        this.mViewStub.setLayoutResource(R.layout.activity_add_source);
        this.mViewStub.inflate();
        this.mCardMultilineWidget = (CardMultilineWidget)this.findViewById(R.id.add_source_card_entry_widget);
        this.initEnterListeners((View)this.mCardMultilineWidget);
        boolean shouldShowPostalCode = this.getIntent().getBooleanExtra(EXTRA_SHOULD_REQUIRE_POSTAL_CODE, false);
        this.mUpdatesCustomer = this.getIntent().getBooleanExtra(EXTRA_UPDATE_CUSTOMER, false);
        this.mStartedFromPaymentSession = this.getIntent().getBooleanExtra("payment_session_active", true);
        this.mCardMultilineWidget.setShouldShowPostalCode(shouldShowPostalCode);
        if (this.mUpdatesCustomer && !this.getIntent().getBooleanExtra(EXTRA_PROXY_DELAY, false)) {
            this.initCustomerSessionTokens();
        }
        this.setTitle(R.string.title_add_a_card);
    }

    private void initEnterListeners(@NonNull View cardMultilineWidget) {
        OnEditorActionListenerImpl listener = new OnEditorActionListenerImpl(this, (InputMethodManager)this.getSystemService("input_method"));
        ((TextView)cardMultilineWidget.findViewById(R.id.et_add_source_card_number_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)cardMultilineWidget.findViewById(R.id.et_add_source_expiry_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)cardMultilineWidget.findViewById(R.id.et_add_source_cvc_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
        ((TextView)cardMultilineWidget.findViewById(R.id.et_add_source_postal_ml)).setOnEditorActionListener((TextView.OnEditorActionListener)listener);
    }

    @VisibleForTesting
    void initCustomerSessionTokens() {
        this.logToCustomerSessionIf(TOKEN_ADD_PAYMENT_METHOD_ACTIVITY, this.mUpdatesCustomer);
        this.logToCustomerSessionIf("PaymentSession", this.mStartedFromPaymentSession);
    }

    @Override
    protected void onActionSave() {
        if (this.mCardMultilineWidget == null) {
            return;
        }
        this.createPaymentMethod(Objects.requireNonNull(this.mStripe));
    }

    @VisibleForTesting
    void createPaymentMethod(@NonNull Stripe stripe) {
        PaymentMethodCreateParams.Card card = Objects.requireNonNull(this.mCardMultilineWidget).getPaymentMethodCard();
        PaymentMethod.BillingDetails billingDetails = this.mCardMultilineWidget.getPaymentMethodBillingDetails();
        if (card == null) {
            return;
        }
        PaymentMethodCreateParams paymentMethodCreateParams = PaymentMethodCreateParams.create(card, billingDetails);
        this.setCommunicatingProgress(true);
        stripe.createPaymentMethod(paymentMethodCreateParams, new PaymentMethodCallbackImpl(this, this.mUpdatesCustomer));
    }

    private void attachPaymentMethodToCustomer(@NonNull PaymentMethod paymentMethod) {
        PaymentMethodRetrievalListenerImpl listener = new PaymentMethodRetrievalListenerImpl(this);
        CustomerSession.getInstance().attachPaymentMethod(Objects.requireNonNull(paymentMethod.id), listener);
    }

    private void logToCustomerSessionIf(@NonNull String logToken, boolean condition) {
        if (condition) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(logToken);
        }
    }

    private void finishWithPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.setCommunicatingProgress(false);
        Intent intent = new Intent().putExtra(EXTRA_NEW_PAYMENT_METHOD, paymentMethod.toJson().toString());
        this.setResult(-1, intent);
        this.finish();
    }

    boolean hasValidCard() {
        return Objects.requireNonNull(this.mCardMultilineWidget).getCard() != null;
    }

    @Nullable
    IBinder getWindowToken() {
        return this.mViewStub.getWindowToken();
    }

    @Override
    protected void setCommunicatingProgress(boolean communicating) {
        super.setCommunicatingProgress(communicating);
        if (this.mCardMultilineWidget != null) {
            this.mCardMultilineWidget.setEnabled(!communicating);
        }
    }

    @VisibleForTesting
    static final class OnEditorActionListenerImpl
    implements TextView.OnEditorActionListener {
        @NonNull
        private final AddPaymentMethodActivity mActivity;
        @NonNull
        private final InputMethodManager mInputMethodManager;

        OnEditorActionListenerImpl(@NonNull AddPaymentMethodActivity activity, @NonNull InputMethodManager inputMethodManager) {
            this.mActivity = activity;
            this.mInputMethodManager = inputMethodManager;
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            if (actionId == 6) {
                if (this.mActivity.hasValidCard()) {
                    this.mInputMethodManager.hideSoftInputFromWindow(this.mActivity.getWindowToken(), 0);
                }
                this.mActivity.onActionSave();
                return true;
            }
            return false;
        }
    }

    private static abstract class ActivityPaymentMethodCallback<A extends Activity>
    implements ApiResultCallback<PaymentMethod> {
        @NonNull
        private final WeakReference<A> mActivityRef;

        ActivityPaymentMethodCallback(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        public A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    private static final class PaymentMethodRetrievalListenerImpl
    extends CustomerSession.ActivityPaymentMethodRetrievalListener<AddPaymentMethodActivity> {
        private PaymentMethodRetrievalListenerImpl(@NonNull AddPaymentMethodActivity activity) {
            super(activity);
        }

        @Override
        public void onPaymentMethodRetrieved(@NonNull PaymentMethod paymentMethod) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.finishWithPaymentMethod(paymentMethod);
        }

        @Override
        public void onError(int errorCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.setCommunicatingProgress(false);
        }
    }

    private static final class PaymentMethodCallbackImpl
    extends ActivityPaymentMethodCallback<AddPaymentMethodActivity> {
        private final boolean mUpdatesCustomer;

        private PaymentMethodCallbackImpl(@NonNull AddPaymentMethodActivity activity, boolean updatesCustomer) {
            super(activity);
            this.mUpdatesCustomer = updatesCustomer;
        }

        @Override
        public void onError(@NonNull Exception error) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.setCommunicatingProgress(false);
            activity.showError(error.getLocalizedMessage());
        }

        @Override
        public void onSuccess(@NonNull PaymentMethod paymentMethod) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            if (this.mUpdatesCustomer) {
                activity.attachPaymentMethodToCustomer(paymentMethod);
            } else {
                activity.finishWithPaymentMethod(paymentMethod);
            }
        }
    }
}

