/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ApiVersion;
import com.stripe.android.RequestOptions;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.utils.ObjectUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

final class StripeRequest {
    private static final String CHARSET = "UTF-8";
    @NonNull
    final Method method;
    @Nullable
    final Map<String, ?> params;
    @NonNull
    final RequestOptions options;
    @NonNull
    private final String mUrl;

    @NonNull
    static StripeRequest createGet(@NonNull String url, @NonNull RequestOptions options) {
        return new StripeRequest(Method.GET, url, null, options);
    }

    @NonNull
    static StripeRequest createGet(@NonNull String url, @NonNull Map<String, ?> params, @NonNull RequestOptions options) {
        return new StripeRequest(Method.GET, url, params, options);
    }

    @NonNull
    static StripeRequest createPost(@NonNull String url, @NonNull RequestOptions options) {
        return new StripeRequest(Method.POST, url, null, options);
    }

    @NonNull
    static StripeRequest createPost(@NonNull String url, @NonNull Map<String, ?> params, @NonNull RequestOptions options) {
        return new StripeRequest(Method.POST, url, params, options);
    }

    @NonNull
    static StripeRequest createDelete(@NonNull String url, @NonNull RequestOptions options) {
        return new StripeRequest(Method.DELETE, url, null, options);
    }

    private StripeRequest(@NonNull Method method, @NonNull String url, @Nullable Map<String, ?> params, @NonNull RequestOptions options) {
        this.method = method;
        this.mUrl = url;
        this.params = params;
        this.options = options;
    }

    @NonNull
    String getUrl() throws UnsupportedEncodingException, InvalidRequestException {
        return Method.GET == this.method ? this.urlWithQuery() : this.mUrl;
    }

    @NonNull
    String getContentType() {
        String mimeType = 1 == this.options.getRequestType() ? "application/json" : "application/x-www-form-urlencoded";
        return String.format(Locale.ROOT, "%s; charset=%s", mimeType, CHARSET);
    }

    @NonNull
    Map<String, String> getHeaders(@NonNull ApiVersion apiVersion) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format(Locale.ROOT, "Stripe/v1 AndroidBindings/%s", "9.2.0"));
        headers.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", this.options.getApiKey()));
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        ((AbstractMap)propertyMap).put("java.version", System.getProperty("java.version"));
        ((AbstractMap)propertyMap).put("os.name", "android");
        ((AbstractMap)propertyMap).put("os.version", String.valueOf(Build.VERSION.SDK_INT));
        ((AbstractMap)propertyMap).put("bindings.version", "9.2.0");
        ((AbstractMap)propertyMap).put("lang", "Java");
        ((AbstractMap)propertyMap).put("publisher", "Stripe");
        headers.put("X-Stripe-Client-User-Agent", new JSONObject(propertyMap).toString());
        headers.put("Stripe-Version", apiVersion.getCode());
        if (this.options.getStripeAccount() != null) {
            headers.put("Stripe-Account", this.options.getStripeAccount());
        }
        return headers;
    }

    @NonNull
    String createQuery() throws InvalidRequestException, UnsupportedEncodingException {
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Parameter flatParam : this.flattenParams(this.params)) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(this.urlEncodePair(flatParam.key, flatParam.value));
        }
        return queryStringBuffer.toString();
    }

    boolean urlStartsWith(String ... urlBases) {
        for (String urlBase : urlBases) {
            if (!this.mUrl.startsWith(urlBase)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private String urlWithQuery() throws InvalidRequestException, UnsupportedEncodingException {
        String query = this.createQuery();
        if (query.isEmpty()) {
            return this.mUrl;
        }
        String separator = this.mUrl.contains("?") ? "&" : "?";
        return String.format(Locale.ROOT, "%s%s%s", this.mUrl, separator, query);
    }

    @NonNull
    private List<Parameter> flattenParams(@Nullable Map<String, ?> params) throws InvalidRequestException {
        return this.flattenParamsMap(params, null);
    }

    @NonNull
    private List<Parameter> flattenParamsList(@NonNull List<?> params, @NonNull String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params.isEmpty()) {
            flatParams.add(new Parameter(keyPrefix, ""));
        } else {
            String newPrefix = String.format(Locale.ROOT, "%s[]", keyPrefix);
            for (Object param : params) {
                flatParams.addAll(this.flattenParamsValue(param, newPrefix));
            }
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsMap(@Nullable Map<String, ?> params, @Nullable String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params == null) {
            return flatParams;
        }
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newPrefix = keyPrefix != null ? String.format(Locale.ROOT, "%s[%s]", keyPrefix, key) : key;
            flatParams.addAll(this.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsValue(@Nullable Object value, @NonNull String keyPrefix) throws InvalidRequestException {
        List<Parameter> flatParams;
        if (value instanceof Map) {
            flatParams = this.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof List) {
            flatParams = this.flattenParamsList((List)value, keyPrefix);
        } else {
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null, null, null, null);
            }
            if (value == null) {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, value.toString()));
            }
        }
        return flatParams;
    }

    @NonNull
    private String urlEncodePair(@NonNull String k, @NonNull String v) throws UnsupportedEncodingException {
        return String.format(Locale.ROOT, "%s=%s", this.urlEncode(k), this.urlEncode(v));
    }

    @Nullable
    private String urlEncode(@Nullable String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.method, this.mUrl, this.params, this.options});
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof StripeRequest && this.typedEquals((StripeRequest)obj);
    }

    private boolean typedEquals(@NonNull StripeRequest request) {
        return ObjectUtils.equals((Object)this.method, (Object)request.method) && ObjectUtils.equals(this.mUrl, request.mUrl) && ObjectUtils.equals(this.params, request.params) && ObjectUtils.equals(this.options, request.options);
    }

    private static final class Parameter {
        @NonNull
        private final String key;
        @NonNull
        private final String value;

        Parameter(@NonNull String key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }
    }

    static enum Method {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE");

        @NonNull
        final String code;

        private Method(String code) {
            this.code = code;
        }
    }
}

