/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Stripe3ds2AuthParams {
    static final String FIELD_APP = "app";
    static final String FIELD_SOURCE = "source";
    private static final String FIELD_SDK_APP_ID = "sdkAppID";
    private static final String FIELD_SDK_TRANS_ID = "sdkTransID";
    private static final String FIELD_SDK_ENC_DATA = "sdkEncData";
    private static final String FIELD_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";
    private static final String FIELD_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
    private static final String FIELD_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
    private static final String FIELD_MESSAGE_VERSION = "messageVersion";
    private static final String FIELD_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
    private static final String FIELD_SDK_INTERFACE = "sdkInterface";
    private static final String FIELD_SDK_UI_TYPE = "sdkUiType";
    @NonNull
    private final String mSourceId;
    @NonNull
    private final String mDeviceData;
    @NonNull
    private final String mSdkAppId;
    @NonNull
    private final String mSdkReferenceNumber;
    @NonNull
    private final String mSdkTransactionId;
    @NonNull
    private final String mSdkEphemeralPublicKey;
    @NonNull
    private final String mMessageVersion;
    private final int mMaxTimeout;

    Stripe3ds2AuthParams(@NonNull String sourceId, @NonNull String sdkAppId, @NonNull String sdkReferenceNumber, @NonNull String sdkTransactionId, @NonNull String deviceData, @NonNull String sdkEphemeralPublicKey, @NonNull String messageVersion, int maxTimeout) {
        this.mSourceId = sourceId;
        this.mSdkAppId = sdkAppId;
        this.mSdkReferenceNumber = sdkReferenceNumber;
        this.mDeviceData = deviceData;
        this.mSdkTransactionId = sdkTransactionId;
        this.mSdkEphemeralPublicKey = sdkEphemeralPublicKey;
        this.mMessageVersion = messageVersion;
        this.mMaxTimeout = maxTimeout;
    }

    @NonNull
    Map<String, Object> toParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(FIELD_SOURCE, this.mSourceId);
        params.put(FIELD_APP, this.createAppParams().toString());
        return params;
    }

    @NonNull
    private JSONObject createAppParams() {
        JSONObject appParams = new JSONObject();
        try {
            appParams.put(FIELD_SDK_APP_ID, (Object)this.mSdkAppId);
            appParams.put(FIELD_SDK_TRANS_ID, (Object)this.mSdkTransactionId);
            appParams.put(FIELD_SDK_ENC_DATA, (Object)this.mDeviceData);
            appParams.put(FIELD_SDK_EPHEM_PUB_KEY, (Object)new JSONObject(this.mSdkEphemeralPublicKey));
            appParams.put(FIELD_SDK_MAX_TIMEOUT, this.mMaxTimeout);
            appParams.put(FIELD_SDK_REFERENCE_NUMBER, (Object)this.mSdkReferenceNumber);
            appParams.put(FIELD_MESSAGE_VERSION, (Object)this.mMessageVersion);
            appParams.put(FIELD_DEVICE_RENDER_OPTIONS, (Object)this.createDeviceRenderOptions());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return appParams;
    }

    @NonNull
    private JSONObject createDeviceRenderOptions() {
        JSONObject deviceRenderOptions = new JSONObject();
        try {
            deviceRenderOptions.put(FIELD_SDK_INTERFACE, (Object)"03");
            deviceRenderOptions.put(FIELD_SDK_UI_TYPE, (Object)new JSONArray(Arrays.asList("01", "02", "03", "04", "05")));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return deviceRenderOptions;
    }
}

