/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentAuthResult;
import com.stripe.android.PaymentAuthenticationController;
import com.stripe.android.RequestOptions;
import com.stripe.android.SourceCallback;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.TokenCallback;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class Stripe {
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final StripeNetworkUtils mStripeNetworkUtils;
    @NonNull
    private final PaymentAuthenticationController mPaymentAuthenticationController;
    @NonNull
    private final TokenCreator mTokenCreator;
    @NonNull
    private final ApiKeyValidator mApiKeyValidator = new ApiKeyValidator();
    private String mDefaultPublishableKey;
    @Nullable
    private String mStripeAccount;

    public Stripe(@NonNull Context context) {
        this(context, new StripeApiHandler(context), new StripeNetworkUtils(context), null);
    }

    public Stripe(@NonNull Context context, @NonNull String publishableKey) {
        this(context, new StripeApiHandler(context), new StripeNetworkUtils(context), ApiKeyValidator.get().requireValid(publishableKey));
    }

    Stripe(@NonNull Context context, @NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @Nullable String publishableKey) {
        this(apiHandler, stripeNetworkUtils, new PaymentAuthenticationController(context, apiHandler), publishableKey);
    }

    Stripe(final @NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @NonNull PaymentAuthenticationController paymentAuthenticationController, @Nullable String publishableKey) {
        this(apiHandler, stripeNetworkUtils, paymentAuthenticationController, publishableKey, new TokenCreator(){

            @Override
            public void create(@NonNull Map<String, Object> tokenParams, @NonNull RequestOptions requestOptions, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
                Stripe.executeTask(executor, new CreateTokenTask(apiHandler, tokenParams, requestOptions, tokenType, callback));
            }
        });
    }

    @VisibleForTesting
    Stripe(@NonNull StripeApiHandler apiHandler, @NonNull StripeNetworkUtils stripeNetworkUtils, @NonNull PaymentAuthenticationController paymentAuthenticationController, @Nullable String publishableKey, @NonNull TokenCreator tokenCreator) {
        this.mApiHandler = apiHandler;
        this.mStripeNetworkUtils = stripeNetworkUtils;
        this.mPaymentAuthenticationController = paymentAuthenticationController;
        this.mTokenCreator = tokenCreator;
        this.mDefaultPublishableKey = publishableKey != null ? this.mApiKeyValidator.requireValid(publishableKey) : null;
    }

    private void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntentParams confirmPaymentIntentParams, @NonNull String publishableKey) {
        this.mPaymentAuthenticationController.startConfirmAndAuth(this, activity, confirmPaymentIntentParams, publishableKey);
    }

    public void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntentParams confirmPaymentIntentParams) {
        this.startPaymentAuth(activity, confirmPaymentIntentParams, this.mDefaultPublishableKey);
    }

    private void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull String publishableKey) {
        this.mPaymentAuthenticationController.startAuth(activity, paymentIntent, publishableKey);
    }

    public void startPaymentAuth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
        this.startPaymentAuth(activity, paymentIntent, this.mDefaultPublishableKey);
    }

    private boolean onPaymentAuthResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentAuthResult> callback) {
        if (data != null && this.mPaymentAuthenticationController.shouldHandleResult(requestCode, resultCode, data)) {
            this.mPaymentAuthenticationController.handleResult(this, data, publishableKey, callback);
            return true;
        }
        return false;
    }

    public boolean onPaymentAuthResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ApiResultCallback<PaymentAuthResult> callback) {
        return this.onPaymentAuthResult(requestCode, resultCode, data, this.mDefaultPublishableKey, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull TokenCallback callback) {
        this.createBankAccountToken(bankAccount, this.mDefaultPublishableKey, null, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(bankAccount, "Required parameter: 'bankAccount' is requred to create a token");
        this.createTokenFromParams(this.mStripeNetworkUtils.hashMapFromBankAccount(bankAccount), publishableKey, "bank_account", executor, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull TokenCallback callback) {
        this.createPiiToken(personalId, this.mDefaultPublishableKey, null, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromPersonalId(personalId), publishableKey, "pii", executor, callback);
    }

    @Nullable
    public Token createBankAccountTokenSynchronous(@NonNull BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccountTokenSynchronous(bankAccount, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createBankAccountTokenSynchronous(@NonNull BankAccount bankAccount, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.hashMapFromBankAccount(bankAccount), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "bank_account");
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull TokenCallback callback) {
        this.createCvcUpdateToken(cvc, this.mDefaultPublishableKey, null, callback);
    }

    public void createCvcUpdateToken(@NonNull @Size(min=3L, max=4L) String cvc, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.mapFromCvc(cvc), publishableKey, "cvc_update", executor, callback);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback) {
        this.createSource(sourceParams, callback, this.mDefaultPublishableKey, null);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback, @NonNull String publishableKey, @Nullable Executor executor) {
        Stripe.executeTask(executor, new CreateSourceTask(this.mApiHandler, sourceParams, publishableKey, this.mStripeAccount, callback));
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback) {
        this.createPaymentMethod(paymentMethodCreateParams, callback, this.mDefaultPublishableKey, null);
    }

    public void createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull ApiResultCallback<PaymentMethod> callback, @NonNull String publishableKey, @Nullable Executor executor) {
        Stripe.executeTask(executor, new CreatePaymentMethodTask(this.mApiHandler, paymentMethodCreateParams, publishableKey, this.mStripeAccount, callback));
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(card, "Required Parameter: 'card' is required to create a token");
        this.createTokenFromParams(this.mStripeNetworkUtils.hashMapFromCard(card), publishableKey, "card", executor, callback);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createSourceSynchronous(params, this.mDefaultPublishableKey);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.createSource(params, RequestOptions.createForApi(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrievePaymentIntent(paymentIntentParams, RequestOptions.createForApi(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return this.retrievePaymentIntentSynchronous(paymentIntentParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public PaymentIntent confirmPaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.confirmPaymentIntent(paymentIntentParams, RequestOptions.createForApi(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentMethod createPaymentMethodSynchronous(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.createPaymentMethod(paymentMethodCreateParams, RequestOptions.createForApi(publishableKey, this.mStripeAccount));
    }

    @Nullable
    public PaymentMethod createPaymentMethodSynchronous(@NonNull PaymentMethodCreateParams paymentMethodCreateParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        return this.createPaymentMethodSynchronous(paymentMethodCreateParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createTokenSynchronous(@NonNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createTokenSynchronous(@NonNull Card card, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(this.mStripeNetworkUtils.hashMapFromCard(card), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "card");
    }

    @Nullable
    public Token createPiiTokenSynchronous(@NonNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createPiiTokenSynchronous(personalId, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createPiiTokenSynchronous(@NonNull String personalId, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(StripeNetworkUtils.hashMapFromPersonalId(personalId), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "pii");
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCvcUpdateTokenSynchronous(cvc, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createCvcUpdateTokenSynchronous(@NonNull String cvc, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.mApiHandler.createToken(StripeNetworkUtils.mapFromCvc(cvc), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "cvc_update");
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createAccountTokenSynchronous(accountParams, this.mDefaultPublishableKey);
    }

    @Nullable
    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            return this.mApiHandler.createToken(accountParams.toParamMap(), RequestOptions.createForApi(publishableKey, this.mStripeAccount), "account");
        }
        catch (CardException cardException) {
            return null;
        }
    }

    @Nullable
    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.retrieveSourceSynchronous(sourceId, clientSecret, this.mDefaultPublishableKey);
    }

    @Nullable
    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.mApiHandler.retrieveSource(sourceId, clientSecret, RequestOptions.createForApi(publishableKey, this.mStripeAccount));
    }

    @Deprecated
    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) {
        this.mDefaultPublishableKey = this.mApiKeyValidator.requireValid(publishableKey);
    }

    public void setStripeAccount(@NonNull @Size(min=1L) String stripeAccount) {
        this.mStripeAccount = stripeAccount;
    }

    private void createTokenFromParams(@NonNull Map<String, Object> tokenParams, @NonNull @Size(min=1L) String publishableKey, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
        Objects.requireNonNull(callback, "Required Parameter: 'callback' is required to use the created token and handle errors");
        this.mTokenCreator.create(tokenParams, RequestOptions.createForApi(publishableKey, this.mStripeAccount), tokenType, executor, callback);
    }

    private static void executeTask(@Nullable Executor executor, @NonNull AsyncTask<Void, Void, ?> task) {
        if (executor != null) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    private static class CreateTokenTask
    extends ApiOperation<Token> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Map<String, Object> mTokenParams;
        @NonNull
        private final RequestOptions mRequestOptions;
        @NonNull
        private final String mTokenType;

        CreateTokenTask(@NonNull StripeApiHandler apiHandler, @NonNull Map<String, Object> tokenParams, @NonNull RequestOptions requestOptions, @NonNull String tokenType, @NonNull TokenCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mTokenParams = tokenParams;
            this.mTokenType = tokenType;
            this.mRequestOptions = requestOptions;
        }

        @Override
        @Nullable
        Token getResult() throws StripeException {
            return this.mApiHandler.createToken(this.mTokenParams, this.mRequestOptions, this.mTokenType);
        }
    }

    private static class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final PaymentMethodCreateParams mPaymentMethodCreateParams;
        @NonNull
        private final RequestOptions mRequestOptions;

        CreatePaymentMethodTask(@NonNull StripeApiHandler apiHandler, @NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull ApiResultCallback<PaymentMethod> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mPaymentMethodCreateParams = paymentMethodCreateParams;
            this.mRequestOptions = RequestOptions.createForApi(publishableKey, stripeAccount);
        }

        @Override
        @Nullable
        PaymentMethod getResult() throws StripeException {
            return this.mApiHandler.createPaymentMethod(this.mPaymentMethodCreateParams, this.mRequestOptions);
        }
    }

    private static class CreateSourceTask
    extends ApiOperation<Source> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final SourceParams mSourceParams;
        @NonNull
        private final RequestOptions mRequestOptions;

        CreateSourceTask(@NonNull StripeApiHandler apiHandler, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull SourceCallback callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mSourceParams = sourceParams;
            this.mRequestOptions = RequestOptions.createForApi(publishableKey, stripeAccount);
        }

        @Override
        @Nullable
        Source getResult() throws StripeException {
            return this.mApiHandler.createSource(this.mSourceParams, this.mRequestOptions);
        }
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(@NonNull Map<String, Object> var1, @NonNull RequestOptions var2, @NonNull String var3, @Nullable Executor var4, @NonNull TokenCallback var5);
    }
}

