/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ApiKeyValidator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class RequestOptions {
    @Nullable
    private final String mGuid;
    @Nullable
    private final String mApiKey;
    private final int mRequestType;
    @Nullable
    private final String mStripeAccount;

    @NonNull
    static RequestOptions createForFingerprinting(@NonNull String guid) {
        return new RequestOptions(guid);
    }

    @NonNull
    static RequestOptions createForApi(@NonNull String apiKey) {
        return new RequestOptions(apiKey, null);
    }

    @NonNull
    static RequestOptions createForApi(@NonNull String apiKey, @Nullable String stripeAccount) {
        return new RequestOptions(apiKey, stripeAccount);
    }

    private RequestOptions(@NonNull String apiKey, @Nullable String stripeAccount) {
        this.mRequestType = 0;
        this.mApiKey = new ApiKeyValidator().requireValid(apiKey);
        this.mStripeAccount = stripeAccount;
        this.mGuid = null;
    }

    private RequestOptions(@NonNull String guid) {
        this.mRequestType = 1;
        this.mGuid = guid;
        this.mApiKey = null;
        this.mStripeAccount = null;
    }

    @Nullable
    String getGuid() {
        return this.mGuid;
    }

    @Nullable
    String getApiKey() {
        return this.mApiKey;
    }

    int getRequestType() {
        return this.mRequestType;
    }

    @Nullable
    String getStripeAccount() {
        return this.mStripeAccount;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
        public static final int API = 0;
        public static final int FINGERPRINTING = 1;
    }
}

