/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import a.b.a.a.d.m;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentAuthBypassStarter;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthResult;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.ResultWrapper;
import com.stripe.android.Stripe;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.view.ActivityStarter;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.json.JSONObject;

class PaymentAuthenticationController {
    static final int REQUEST_CODE = 50000;
    private static final String TAG = "PaymentAuthentication";
    private static final String DIRECTORY_SERVER_ID = "F000000000";
    @NonNull
    private final StripeThreeDs2Service mThreeDs2Service;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final MessageVersionRegistry mMessageVersionRegistry;
    @NonNull
    private final String mDirectoryServerId;
    @NonNull
    private final PaymentAuthConfig mConfig;

    PaymentAuthenticationController(@NonNull Context context, @NonNull StripeApiHandler apiHandler) {
        this(context, (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context), apiHandler, new MessageVersionRegistry(), DIRECTORY_SERVER_ID, PaymentAuthConfig.get());
    }

    @VisibleForTesting
    PaymentAuthenticationController(@NonNull Context context, @NonNull StripeThreeDs2Service threeDs2Service, @NonNull StripeApiHandler apiHandler, @NonNull MessageVersionRegistry messageVersionRegistry, @NonNull String directoryServerId, @NonNull PaymentAuthConfig config) {
        this.mConfig = config;
        this.mThreeDs2Service = threeDs2Service;
        this.mThreeDs2Service.initialize(context, (ConfigParameters)new StripeConfigParameters(), null, config.stripe3ds2Config.uiCustomization);
        this.mApiHandler = apiHandler;
        this.mMessageVersionRegistry = messageVersionRegistry;
        this.mDirectoryServerId = directoryServerId;
    }

    void confirmAndAuth(@NonNull Stripe stripe, @NonNull Activity activity, @NonNull PaymentIntentParams paymentIntentParams, final @NonNull String publishableKey) {
        final WeakReference<Activity> activityRef = new WeakReference<Activity>(activity);
        new ConfirmPaymentIntentTask(stripe, activity, paymentIntentParams, publishableKey, new ApiResultCallback<PaymentIntent>(){

            @Override
            public void onSuccess(@NonNull PaymentIntent paymentIntent) {
                PaymentAuthenticationController.this.handleNextAction((Activity)activityRef.get(), paymentIntent, publishableKey);
            }

            @Override
            public void onError(@NonNull Exception e) {
                Log.e((String)PaymentAuthenticationController.TAG, (String)"Exception thrown while confirming PaymentIntent", (Throwable)e);
            }
        }).execute(new Void[0]);
    }

    boolean shouldHandleResult(int requestCode, int resultCode, @Nullable Intent data) {
        return requestCode == 50000 && resultCode == -1 && data != null;
    }

    void handleResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<PaymentAuthResult> listener) {
        String clientSecret = data.getStringExtra("client_secret");
        PaymentIntentParams paymentIntentParams = PaymentIntentParams.createRetrievePaymentIntentParams(clientSecret);
        new RetrievePaymentIntentTask(stripe, paymentIntentParams, publishableKey, new ApiResultCallback<PaymentIntent>(){

            @Override
            public void onSuccess(@NonNull PaymentIntent paymentIntent) {
                listener.onSuccess(new PaymentAuthResult.Builder().setPaymentIntent(paymentIntent).build());
            }

            @Override
            public void onError(@NonNull Exception e) {
                listener.onError(e);
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    void handleNextAction(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull String publishableKey) {
        if (paymentIntent.requiresAction()) {
            PaymentIntent.NextActionType nextActionType = paymentIntent.getNextActionType();
            if (PaymentIntent.NextActionType.UseStripeSdk == nextActionType) {
                PaymentIntent.SdkData sdkData = Objects.requireNonNull(paymentIntent.getStripeSdkData());
                if (sdkData.is3ds2()) {
                    this.begin3ds2Auth(activity, paymentIntent, Stripe3ds2Fingerprint.create(sdkData), publishableKey);
                } else {
                    this.bypassAuth(activity, paymentIntent);
                }
            } else if (PaymentIntent.NextActionType.RedirectToUrl == nextActionType) {
                this.begin3ds1Auth(activity, Objects.requireNonNull(paymentIntent.getRedirectData()));
            } else {
                this.bypassAuth(activity, paymentIntent);
            }
        } else {
            this.bypassAuth(activity, paymentIntent);
        }
    }

    private void bypassAuth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
        new PaymentAuthBypassStarter(activity, 50000).start(paymentIntent);
    }

    private void begin3ds2Auth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull Stripe3ds2Fingerprint stripe3ds2Fingerprint, @NonNull String publishableKey) {
        Transaction transaction = this.mThreeDs2Service.createTransaction(this.mDirectoryServerId, this.mMessageVersionRegistry.getCurrent(), false);
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.mConfig.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.source, areqParams.getSDKAppID(), areqParams.getSDKReferenceNumber(), areqParams.getSDKTransactionID(), areqParams.getDeviceData(), areqParams.getSDKEphemeralPublicKey(), areqParams.getMessageVersion(), timeout);
        this.mApiHandler.start3ds2Auth(authParams, publishableKey, new Stripe3ds2AuthCallback(activity, transaction, timeout, paymentIntent));
    }

    private void begin3ds1Auth(@NonNull Activity activity, @NonNull PaymentIntent.RedirectData redirectData) {
        new PaymentAuthWebViewStarter(activity, 50000).start(redirectData);
    }

    static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        @NonNull
        private final ActivityStarter<Stripe3ds2CompletionStarter.StartData> mStarter;
        @NonNull
        private final PaymentIntent mPaymentIntent;

        @NonNull
        static PaymentAuth3ds2ChallengeStatusReceiver create(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
            return new PaymentAuth3ds2ChallengeStatusReceiver(new Stripe3ds2CompletionStarter(activity, 50000), paymentIntent);
        }

        PaymentAuth3ds2ChallengeStatusReceiver(@NonNull ActivityStarter<Stripe3ds2CompletionStarter.StartData> starter, @NonNull PaymentIntent paymentIntent) {
            this.mStarter = starter;
            this.mPaymentIntent = paymentIntent;
        }

        public void completed(@NonNull CompletionEvent completionEvent) {
            super.completed(completionEvent);
            this.start(Stripe3ds2CompletionStarter.StartData.createForComplete(this.mPaymentIntent, completionEvent.getTransactionStatus()));
        }

        public void cancelled() {
            super.cancelled();
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 1));
        }

        public void timedout() {
            super.timedout();
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 2));
        }

        public void protocolError(@NonNull ProtocolErrorEvent protocolErrorEvent) {
            super.protocolError(protocolErrorEvent);
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 3));
        }

        public void runtimeError(@NonNull RuntimeErrorEvent runtimeErrorEvent) {
            super.runtimeError(runtimeErrorEvent);
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 4));
        }

        private void start(@NonNull Stripe3ds2CompletionStarter.StartData startData) {
            this.mStarter.start(startData);
        }
    }

    private static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<JSONObject> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final Transaction mTransaction;
        private final int mMaxTimeout;
        @NonNull
        private final PaymentIntent mPaymentIntent;

        private Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull Transaction transaction, int maxTimeout, @NonNull PaymentIntent paymentIntent) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mTransaction = transaction;
            this.mMaxTimeout = maxTimeout;
            this.mPaymentIntent = paymentIntent;
        }

        @Override
        public void onSuccess(@NonNull JSONObject result) {
            final Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return;
            }
            JSONObject ares = result.optJSONObject("ares");
            final StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.optString("acsSignedContent"));
            challengeParameters.set3DSServerTransactionID(ares.optString("threeDSServerTransID"));
            challengeParameters.setAcsTransactionID(ares.optString("acsTransID"));
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    Stripe3ds2AuthCallback.this.mTransaction.doChallenge(activity, (ChallengeParameters)challengeParameters, (m)PaymentAuth3ds2ChallengeStatusReceiver.create(activity, Stripe3ds2AuthCallback.this.mPaymentIntent), Stripe3ds2AuthCallback.this.mMaxTimeout);
                }
            });
        }

        @Override
        public void onError(@NonNull Exception e) {
        }
    }

    private static final class ConfirmPaymentIntentTask
    extends AsyncTask<Void, Void, ResultWrapper<PaymentIntent>> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final PaymentIntentParams mParams;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final ApiResultCallback<PaymentIntent> mListener;

        private ConfirmPaymentIntentTask(@NonNull Stripe stripe, @NonNull Activity activity, @NonNull PaymentIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentIntent> listener) {
            this.mStripe = stripe;
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mParams = params;
            this.mPublishableKey = publishableKey;
            this.mListener = listener;
        }

        protected ResultWrapper<PaymentIntent> doInBackground(Void ... voids) {
            try {
                PaymentIntent paymentIntent = this.mStripe.confirmPaymentIntentSynchronous(this.mParams, this.mPublishableKey);
                return new ResultWrapper<PaymentIntent>(paymentIntent);
            }
            catch (StripeException stripeException) {
                return new ResultWrapper<PaymentIntent>(stripeException);
            }
        }

        protected void onPostExecute(@NonNull ResultWrapper<PaymentIntent> resultWrapper) {
            PaymentIntent paymentIntent = (PaymentIntent)resultWrapper.result;
            if (paymentIntent != null) {
                Activity activity = (Activity)this.mActivityRef.get();
                if (activity != null) {
                    this.mListener.onSuccess(paymentIntent);
                } else {
                    this.mListener.onError(new RuntimeException("Activity has been GCed"));
                }
            } else if (resultWrapper.error != null) {
                this.mListener.onError(resultWrapper.error);
            } else {
                this.mListener.onError(new RuntimeException("Somehow got neither a PaymentIntent response or an error response"));
            }
        }
    }

    private static final class RetrievePaymentIntentTask
    extends AsyncTask<Void, Void, ResultWrapper<PaymentIntent>> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final PaymentIntentParams mParams;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final ApiResultCallback<PaymentIntent> mListener;

        private RetrievePaymentIntentTask(@NonNull Stripe stripe, @NonNull PaymentIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentIntent> listener) {
            this.mStripe = stripe;
            this.mParams = params;
            this.mPublishableKey = publishableKey;
            this.mListener = listener;
        }

        protected ResultWrapper<PaymentIntent> doInBackground(Void ... voids) {
            try {
                PaymentIntent paymentIntent = this.mStripe.retrievePaymentIntentSynchronous(this.mParams, this.mPublishableKey);
                return new ResultWrapper<PaymentIntent>(paymentIntent);
            }
            catch (StripeException e) {
                return new ResultWrapper<PaymentIntent>(e);
            }
        }

        protected void onPostExecute(@NonNull ResultWrapper<PaymentIntent> resultWrapper) {
            PaymentIntent paymentIntent = (PaymentIntent)resultWrapper.result;
            if (paymentIntent != null) {
                this.mListener.onSuccess(paymentIntent);
            } else if (resultWrapper.error != null) {
                this.mListener.onError(resultWrapper.error);
            } else {
                this.mListener.onError(new RuntimeException("Somehow got neither a PaymentIntent response or an error response"));
            }
        }
    }
}

