/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ErrorParser;
import com.stripe.android.LoggingUtils;
import com.stripe.android.RequestExecutor;
import com.stripe.android.RequestOptions;
import com.stripe.android.Stripe3DS2AuthParams;
import com.stripe.android.StripeError;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.TelemetryClientUtil;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class StripeApiHandler {
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    @NonNull
    private final LoggingUtils mLoggingUtils;
    @NonNull
    private final TelemetryClientUtil mTelemetryClientUtil;
    @NonNull
    private final StripeNetworkUtils mNetworkUtils;
    @NonNull
    private final RequestExecutor mRequestExecutor;
    private final boolean mShouldLogRequest;

    StripeApiHandler(@NonNull Context context) {
        this(context, new RequestExecutor(), true);
    }

    @VisibleForTesting
    StripeApiHandler(@NonNull Context context, @NonNull RequestExecutor requestExecutor, boolean shouldLogRequest) {
        this.mRequestExecutor = requestExecutor;
        this.mShouldLogRequest = shouldLogRequest;
        this.mLoggingUtils = new LoggingUtils(context);
        this.mTelemetryClientUtil = new TelemetryClientUtil(context);
        this.mNetworkUtils = new StripeNetworkUtils(context);
    }

    boolean logApiCall(@NonNull Map<String, Object> loggingMap, @NonNull RequestOptions options) {
        if (!this.mShouldLogRequest) {
            return false;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return false;
        }
        return this.fireAndForgetApiCall(StripeRequest.createGet("https://q.stripe.com", loggingMap, options));
    }

    @Nullable
    PaymentIntent confirmPaymentIntent(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        this.mNetworkUtils.addUidParamsToPaymentIntent(paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.logTelemetryData();
            SourceParams sourceParams = paymentIntentParams.getSourceParams();
            String sourceType = sourceParams != null ? sourceParams.getType() : null;
            this.logApiCall(this.mLoggingUtils.getPaymentIntentConfirmationParams(null, apiKey, sourceType), RequestOptions.builder(publishableKey).build());
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = this.requestData(StripeRequest.createPost(StripeApiHandler.getConfirmPaymentIntentUrl(paymentIntentId), paramMap, options));
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentIntent retrievePaymentIntent(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.logTelemetryData();
            this.logApiCall(this.mLoggingUtils.getPaymentIntentRetrieveParams(null, apiKey), RequestOptions.builder(publishableKey).build());
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = this.requestData(StripeRequest.createGet(StripeApiHandler.getRetrievePaymentIntentUrl(paymentIntentId), paramMap, options));
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source createSource(@NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = sourceParams.toParamMap();
        this.mNetworkUtils.addUidParams(paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.logTelemetryData();
            this.logApiCall(this.mLoggingUtils.getSourceCreationParams(null, apiKey, sourceParams.getType()), RequestOptions.builder(publishableKey).build());
            StripeResponse response = this.requestData(StripeRequest.createPost(StripeApiHandler.getSourcesUrl(), paramMap, options));
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, String> paramMap = SourceParams.createRetrieveSourceParams(clientSecret);
        RequestOptions options = stripeAccount == null ? RequestOptions.builder(publishableKey).build() : RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            StripeResponse response = this.requestData(StripeRequest.createGet(StripeApiHandler.getRetrieveSourceApiUrl(sourceId), paramMap, options));
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentMethod createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> params = paymentMethodCreateParams.toParamMap();
        this.mNetworkUtils.addUidParams(params);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        String apiKey = options.getPublishableApiKey();
        if (StripeTextUtils.isBlank(apiKey)) {
            return null;
        }
        this.logTelemetryData();
        this.logApiCall(this.mLoggingUtils.getPaymentMethodCreationParams(null, apiKey), RequestOptions.builder(publishableKey).build());
        try {
            StripeResponse response = this.requestData(StripeRequest.createPost(StripeApiHandler.getPaymentMethodsUrl(), params, options));
            return PaymentMethod.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Token createToken(@NonNull Map<String, Object> tokenParams, @NonNull RequestOptions options, @NonNull String tokenType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            List loggingTokens = (List)tokenParams.get("product_usage");
            tokenParams.remove("product_usage");
            this.logTelemetryData();
            this.logApiCall(this.mLoggingUtils.getTokenCreationParams(loggingTokens, apiKey, tokenType), options);
        }
        catch (ClassCastException classCastEx) {
            tokenParams.remove("product_usage");
        }
        return this.requestToken(StripeApiHandler.getTokensUrl(), tokenParams, options);
    }

    @Nullable
    Source addCustomerSource(@NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", sourceId);
        this.logApiCall(this.mLoggingUtils.getAddSourceParams(productUsageTokens, publicKey, sourceType), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getAddCustomerSourceUrl(customerId), params, RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    Source deleteCustomerSource(@NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        this.logApiCall(this.mLoggingUtils.getDeleteSourceParams(productUsageTokens, publicKey), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createDelete(StripeApiHandler.getDeleteCustomerSourceUrl(customerId, sourceId), RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    PaymentMethod attachPaymentMethod(@NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String paymentMethodId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customer", customerId);
        this.logApiCall(this.mLoggingUtils.getAttachPaymentMethodParams(productUsageTokens, publicKey), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getAttachPaymentMethodUrl(paymentMethodId), params, RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    @Nullable
    PaymentMethod detachPaymentMethod(@NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String paymentMethodId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        this.logApiCall(this.mLoggingUtils.getDetachPaymentMethodParams(productUsageTokens, publicKey), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(this.getDetachPaymentMethodUrl(paymentMethodId), RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return PaymentMethod.fromString(response.getResponseBody());
    }

    @NonNull
    List<PaymentMethod> getPaymentMethods(@NonNull String customerId, @NonNull String paymentMethodType, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        JSONArray data;
        HashMap<String, String> queryParams = new HashMap<String, String>(2);
        queryParams.put("customer", customerId);
        queryParams.put("type", paymentMethodType);
        this.logApiCall(this.mLoggingUtils.getDetachPaymentMethodParams(productUsageTokens, publicKey), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createGet(StripeApiHandler.getPaymentMethodsUrl(), queryParams, RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        try {
            data = new JSONObject(response.getResponseBody()).optJSONArray("data");
        }
        catch (JSONException e) {
            return new ArrayList<PaymentMethod>();
        }
        ArrayList<PaymentMethod> paymentMethods = new ArrayList<PaymentMethod>();
        for (int i = 0; i < data.length(); ++i) {
            paymentMethods.add(PaymentMethod.fromJson(data.optJSONObject(i)));
        }
        return paymentMethods;
    }

    @Nullable
    Customer setDefaultCustomerSource(@NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("default_source", sourceId);
        this.logApiCall(this.mLoggingUtils.getEventLoggingParams(productUsageTokens, sourceType, null, publicKey, "default_source"), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getRetrieveCustomerUrl(customerId), params, RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer setCustomerShippingInfo(@NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull ShippingInformation shippingInformation, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("shipping", shippingInformation.toMap());
        this.logApiCall(this.mLoggingUtils.getEventLoggingParams(productUsageTokens, null, null, publicKey, "set_shipping_info"), RequestOptions.builder(publicKey).build());
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getRetrieveCustomerUrl(customerId), params, RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer retrieveCustomer(@NonNull String customerId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        StripeResponse response = this.getStripeResponse(StripeRequest.createGet(StripeApiHandler.getRetrieveCustomerUrl(customerId), RequestOptions.builder(secret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @NonNull
    private static Map<String, String> createVerificationParam(@NonNull String verificationId, @NonNull String userOneTimeCode) {
        HashMap<String, String> verificationMap = new HashMap<String, String>();
        verificationMap.put("id", verificationId);
        verificationMap.put("one_time_code", userOneTimeCode);
        return verificationMap;
    }

    @NonNull
    String retrieveIssuingCardPin(@NonNull String cardId, @NonNull String verificationId, @NonNull String userOneTimeCode, @NonNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("verification", StripeApiHandler.createVerificationParam(verificationId, userOneTimeCode));
        StripeResponse response = this.getStripeResponse(StripeRequest.createGet(StripeApiHandler.getIssuingCardPinUrl(cardId), params, RequestOptions.builder(ephemeralKeySecret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        JSONObject jsonResponse = new JSONObject(response.getResponseBody());
        return jsonResponse.getString("pin");
    }

    void updateIssuingCardPin(@NonNull String cardId, @NonNull String newPin, @NonNull String verificationId, @NonNull String userOneTimeCode, @NonNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("verification", StripeApiHandler.createVerificationParam(verificationId, userOneTimeCode));
        params.put("pin", newPin);
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getIssuingCardPinUrl(cardId), params, RequestOptions.builder(ephemeralKeySecret).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
    }

    @VisibleForTesting
    void start3ds2Auth(@NonNull Stripe3DS2AuthParams authParams, @NonNull String publishableKey) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        StripeResponse response = this.getStripeResponse(StripeRequest.createPost(StripeApiHandler.getApiUrl("3ds2/authenticate"), authParams.toParamMap(), RequestOptions.builder(publishableKey).build()));
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
    }

    @NonNull
    static String getTokensUrl() {
        return StripeApiHandler.getApiUrl("tokens");
    }

    @NonNull
    @VisibleForTesting
    static String getSourcesUrl() {
        return StripeApiHandler.getApiUrl("sources");
    }

    @VisibleForTesting
    @NonNull
    static String getPaymentMethodsUrl() {
        return StripeApiHandler.getApiUrl("payment_methods");
    }

    @VisibleForTesting
    @NonNull
    static String getRetrievePaymentIntentUrl(@NonNull String paymentIntentId) {
        return StripeApiHandler.getApiUrl("payment_intents/%s", paymentIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getConfirmPaymentIntentUrl(@NonNull String paymentIntentId) {
        return StripeApiHandler.getApiUrl("payment_intents/%s/confirm", paymentIntentId);
    }

    @VisibleForTesting
    @NonNull
    static String getAddCustomerSourceUrl(@NonNull String customerId) {
        return StripeApiHandler.getApiUrl("customers/%s/sources", customerId);
    }

    @VisibleForTesting
    @NonNull
    static String getDeleteCustomerSourceUrl(@NonNull String customerId, @NonNull String sourceId) {
        return StripeApiHandler.getApiUrl("customers/%s/sources/%s", customerId, sourceId);
    }

    @VisibleForTesting
    @NonNull
    static String getAttachPaymentMethodUrl(@NonNull String paymentMethodId) {
        return StripeApiHandler.getApiUrl("payment_methods/%s/attach", paymentMethodId);
    }

    @VisibleForTesting
    @NonNull
    String getDetachPaymentMethodUrl(@NonNull String paymentMethodId) {
        return StripeApiHandler.getApiUrl("payment_methods/%s/detach", paymentMethodId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveCustomerUrl(@NonNull String customerId) {
        return StripeApiHandler.getApiUrl("customers/%s", customerId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveSourceApiUrl(@NonNull String sourceId) {
        return StripeApiHandler.getApiUrl("sources/%s", sourceId);
    }

    @VisibleForTesting
    @NonNull
    static String getRetrieveTokenApiUrl(@NonNull String tokenId) {
        return StripeApiHandler.getApiUrl("tokens/%s", tokenId);
    }

    @VisibleForTesting
    @NonNull
    static String getIssuingCardPinUrl(@NonNull String cardId) {
        return StripeApiHandler.getApiUrl("issuing/cards/%s/pin", cardId);
    }

    @NonNull
    private static String getApiUrl(@NonNull String path, Object ... args) {
        return StripeApiHandler.getApiUrl(String.format(Locale.ENGLISH, path, args));
    }

    @NonNull
    private static String getApiUrl(@NonNull String path) {
        return String.format(Locale.ENGLISH, "%s/v1/%s", "https://api.stripe.com", path);
    }

    private void convertErrorsToExceptionsAndThrowIfNecessary(@NonNull StripeResponse response) throws InvalidRequestException, APIException, AuthenticationException, CardException {
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> requestIdList = headers == null ? null : headers.get("Request-Id");
        String requestId = requestIdList != null && requestIdList.size() > 0 ? requestIdList.get(0) : null;
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode, requestId);
        }
    }

    @Nullable
    private JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    private JSONArray listToJsonArray(@Nullable List<?> values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)this.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)this.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireAndForgetApiCall(@NonNull StripeRequest request) {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        boolean isSuccessful = false;
        try {
            StripeResponse response = this.getStripeResponse(request);
            isSuccessful = response.getResponseCode() == 200;
        }
        catch (StripeException stripeException) {
        }
        finally {
            if (allowedToSetTTL) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
        return isSuccessful;
    }

    @NonNull
    private StripeResponse getStripeResponse(@NonNull StripeRequest request) throws InvalidRequestException, APIConnectionException {
        return this.mRequestExecutor.execute(request);
    }

    private void handleAPIError(@Nullable String responseBody, int responseCode, @Nullable String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        StripeError stripeError = ErrorParser.parseError(responseBody);
        switch (responseCode) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, responseCode, stripeError.code, stripeError.declineCode, stripeError, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError.message, requestId, (Integer)responseCode, stripeError);
            }
            case 402: {
                throw new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.declineCode, stripeError.charge, responseCode, stripeError);
            }
            case 403: {
                throw new PermissionException(stripeError.message, requestId, (Integer)responseCode, stripeError);
            }
            case 429: {
                throw new RateLimitException(stripeError.message, stripeError.param, requestId, (Integer)responseCode, stripeError);
            }
        }
        throw new APIException(stripeError.message, requestId, responseCode, stripeError, null);
    }

    @NonNull
    @VisibleForTesting
    StripeResponse requestData(@NonNull StripeRequest request) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        String apiKey = request.options.getPublishableApiKey();
        if (StripeTextUtils.isBlank(apiKey)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.", null, (Integer)0, null);
        }
        StripeResponse response = this.getStripeResponse(request);
        if (response.hasErrorCode()) {
            this.handleAPIError(response.getResponseBody(), response.getResponseCode(), response.getRequestId());
        }
        if (allowedToSetTTL) {
            if (originalDNSCacheTTL == null) {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
            } else {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
            }
        }
        return response;
    }

    @Nullable
    private Token requestToken(@NonNull String url, @NonNull Map<String, Object> params, @NonNull RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse response = this.requestData(StripeRequest.createPost(url, params, options));
        return Token.fromString(response.getResponseBody());
    }

    private void logTelemetryData() {
        Map<String, Object> params = this.mTelemetryClientUtil.createTelemetryMap();
        StripeNetworkUtils.removeNullAndEmptyParams(params);
        if (!this.mShouldLogRequest) {
            return;
        }
        RequestOptions options = RequestOptions.builder(null, "json_data").setGuid(this.mTelemetryClientUtil.getHashedId()).build();
        this.fireAndForgetApiCall(StripeRequest.createPost("https://m.stripe.com/4", params, options));
    }
}

